/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;

class TestCommonIterators {
    TestCommonIterators() {
    }

    @Test
    void testNoDuplicatesFilteringIterator() {
        List<Integer> ints = Arrays.asList(1, 2, 2, 40, 100, 40, 101, 2, 3);
        Iterator iterator = FilteringIterator.noDuplicates(ints.iterator());
        Assertions.assertEquals((Object)1, iterator.next());
        Assertions.assertEquals((Object)2, iterator.next());
        Assertions.assertEquals((Object)40, iterator.next());
        Assertions.assertEquals((Object)100, iterator.next());
        Assertions.assertEquals((Object)101, iterator.next());
        Assertions.assertEquals((Object)3, iterator.next());
    }

    @Test
    void testFirstElement() {
        Object object = new Object();
        Object object2 = new Object();
        Assertions.assertEquals((Object)object, (Object)Iterables.first(Arrays.asList(object, object2)));
        Assertions.assertEquals((Object)object, (Object)Iterables.first(Arrays.asList(object)));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterables.first(Arrays.asList(new Object[0])));
        Assertions.assertEquals((Object)object, (Object)Iterators.first(Arrays.asList(object, object2).iterator()));
        Assertions.assertEquals((Object)object, (Object)Iterators.first(Arrays.asList(object).iterator()));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterators.first(Arrays.asList(new Object[0]).iterator()));
        Assertions.assertEquals((Object)object, (Object)Iterables.firstOrNull(Arrays.asList(object, object2)));
        Assertions.assertEquals((Object)object, (Object)Iterables.firstOrNull(Arrays.asList(object)));
        Assertions.assertNull((Object)Iterables.firstOrNull(Arrays.asList(new Object[0])));
        Assertions.assertEquals((Object)object, (Object)Iterators.firstOrNull(Arrays.asList(object, object2).iterator()));
        Assertions.assertEquals((Object)object, (Object)Iterators.firstOrNull(Arrays.asList(object).iterator()));
        Assertions.assertNull((Object)Iterators.firstOrNull(Arrays.asList(new Object[0]).iterator()));
    }

    @Test
    void testLastElement() {
        Object object = new Object();
        Object object2 = new Object();
        Assertions.assertEquals((Object)object2, (Object)Iterables.last(Arrays.asList(object, object2)));
        Assertions.assertEquals((Object)object, (Object)Iterables.last(Arrays.asList(object)));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterables.last(Arrays.asList(new Object[0])));
        Assertions.assertEquals((Object)object2, (Object)Iterators.last(Arrays.asList(object, object2).iterator()));
        Assertions.assertEquals((Object)object, (Object)Iterators.last(Arrays.asList(object).iterator()));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterators.last(Arrays.asList(new Object[0]).iterator()));
        Assertions.assertEquals((Object)object2, (Object)Iterables.lastOrNull(Arrays.asList(object, object2)));
        Assertions.assertEquals((Object)object, (Object)Iterables.lastOrNull(Arrays.asList(object)));
        Assertions.assertNull((Object)Iterables.lastOrNull(Arrays.asList(new Object[0])));
        Assertions.assertEquals((Object)object2, (Object)Iterators.lastOrNull(Arrays.asList(object, object2).iterator()));
        Assertions.assertEquals((Object)object, (Object)Iterators.lastOrNull(Arrays.asList(object).iterator()));
        Assertions.assertNull((Object)Iterators.lastOrNull(Arrays.asList(new Object[0]).iterator()));
    }

    @Test
    void testSingleElement() {
        Object object = new Object();
        Object object2 = new Object();
        Assertions.assertEquals((Object)object, (Object)Iterables.single(Arrays.asList(object)));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterables.single(Arrays.asList(new Object[0])));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterables.single(Arrays.asList(object, object2)));
        Assertions.assertEquals((Object)object, (Object)Iterators.single(Arrays.asList(object).iterator()));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterators.single(Arrays.asList(new Object[0]).iterator()));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterators.single(Arrays.asList(object, object2).iterator()));
        Assertions.assertEquals((Object)object, (Object)Iterables.singleOrNull(Arrays.asList(object)));
        Assertions.assertNull((Object)Iterables.singleOrNull(Arrays.asList(new Object[0])));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterables.singleOrNull(Arrays.asList(object, object2)));
        Assertions.assertEquals((Object)object, (Object)Iterators.singleOrNull(Arrays.asList(object).iterator()));
        Assertions.assertNull((Object)Iterators.singleOrNull(Arrays.asList(new Object[0]).iterator()));
        Assertions.assertThrows(NoSuchElementException.class, () -> Iterators.singleOrNull(Arrays.asList(object, object2).iterator()));
    }

    @Test
    void getItemFromEnd() {
        List<Integer> ints = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        Assertions.assertEquals((Object)9, (Object)Iterables.fromEnd(ints, (int)0));
        Assertions.assertEquals((Object)8, (Object)Iterables.fromEnd(ints, (int)1));
        Assertions.assertEquals((Object)7, (Object)Iterables.fromEnd(ints, (int)2));
    }

    @Test
    void iteratorsStreamForNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Iterators.stream(null));
    }

    @Test
    void iteratorsStream() {
        List<Object> list = Arrays.asList(1, 2, "3", Character.valueOf('4'), null, "abc", "56789");
        Iterator<Object> iterator = list.iterator();
        Assertions.assertEquals(list, Iterators.stream(iterator).collect(Collectors.toList()));
    }

    @Test
    void iteratorsStreamClosesResourceIterator() {
        List<Object> list = Arrays.asList("a", "b", "c", "def");
        Resource resource = (Resource)Mockito.mock(Resource.class);
        ResourceIterator iterator = Iterators.resourceIterator(list.iterator(), (Resource)resource);
        try (Stream stream = Iterators.stream((Iterator)iterator);){
            Assertions.assertEquals(list, stream.collect(Collectors.toList()));
        }
        ((Resource)Mockito.verify((Object)resource)).close();
    }

    @Test
    void iteratorsStreamCharacteristics() {
        Iterator<Integer> iterator = Arrays.asList(1, 2, 3).iterator();
        int characteristics = 21;
        Stream stream = Iterators.stream(iterator, (int)characteristics);
        Assertions.assertEquals((int)characteristics, (int)stream.spliterator().characteristics());
    }

    @Test
    void iterablesStreamForNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Iterables.stream(null));
    }

    @Test
    void iterablesStream() {
        List<Object> list = Arrays.asList(1, 2, "3", Character.valueOf('4'), null, "abc", "56789");
        Assertions.assertEquals(list, Iterables.stream(list).collect(Collectors.toList()));
    }

    @Test
    void iterablesStreamClosesResourceIterator() {
        List<Object> list = Arrays.asList("a", "b", "c", "def");
        Resource resource = (Resource)Mockito.mock(Resource.class);
        ResourceIterable iterable = () -> Iterators.resourceIterator(list.iterator(), (Resource)resource);
        try (Stream stream = Iterables.stream((Iterable)iterable);){
            Assertions.assertEquals(list, stream.collect(Collectors.toList()));
        }
        ((Resource)Mockito.verify((Object)resource)).close();
    }

    @Test
    void iterablesStreamCharacteristics() {
        List<Integer> iterable = Arrays.asList(1, 2, 3);
        int characteristics = 273;
        Stream stream = Iterables.stream(iterable, (int)characteristics);
        Assertions.assertEquals((int)characteristics, (int)stream.spliterator().characteristics());
    }
}

