/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.collection.LruCache;

class LruCacheTest {
    LruCacheTest() {
    }

    @Test
    void shouldThrowWhenMaxSizeIsNotGreaterThanZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LruCache("TestCache", 0));
    }

    @Test
    void shouldThrowWhenPuttingEntryWithNullKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LruCache("TestCache", 70).put(null, new Object()));
    }

    @Test
    void shouldThrowWhenPuttingEntryWithNullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LruCache("TestCache", 70).put(new Object(), null));
    }

    @Test
    void shouldThrowWhenGettingWithANullKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LruCache("TestCache", 70).get(null));
    }

    @Test
    void shouldThrowWhenRemovingWithANullKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LruCache("TestCache", 70).remove(null));
    }

    @Test
    void shouldWork() {
        LruCache cache = new LruCache("TestCache", 3);
        String s1 = "1";
        Integer key1 = 1;
        String s2 = "2";
        Integer key2 = 2;
        String s3 = "3";
        Integer key3 = 3;
        String s4 = "4";
        Integer key4 = 4;
        String s5 = "5";
        Integer key5 = 5;
        cache.put((Object)key1, (Object)s1);
        cache.put((Object)key2, (Object)s2);
        cache.put((Object)key3, (Object)s3);
        cache.get((Object)key2);
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(key1, key2, key3)), (Object)cache.keySet());
        cache.put((Object)key4, (Object)s4);
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(key2, key3, key4)), (Object)cache.keySet());
        cache.put((Object)key5, (Object)s5);
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(key2, key4, key5)), (Object)cache.keySet());
        int size = cache.size();
        Assertions.assertEquals((int)3, (int)size);
        Assertions.assertNull((Object)cache.get((Object)key1));
        Assertions.assertEquals((Object)s2, (Object)cache.get((Object)key2));
        Assertions.assertNull((Object)cache.get((Object)key3));
        Assertions.assertEquals((Object)s4, (Object)cache.get((Object)key4));
        Assertions.assertEquals((Object)s5, (Object)cache.get((Object)key5));
        cache.clear();
        Assertions.assertEquals((int)0, (int)cache.size());
    }

    @Test
    void shouldResizeTheCache() {
        final HashSet cleaned = new HashSet();
        LruCache<Integer, String> cache = new LruCache<Integer, String>("TestCache", 3){

            public void elementCleaned(String element) {
                cleaned.add(element);
            }
        };
        String s1 = "1";
        Integer key1 = 1;
        String s2 = "2";
        Integer key2 = 2;
        String s3 = "3";
        Integer key3 = 3;
        String s4 = "4";
        Integer key4 = 4;
        String s5 = "5";
        Integer key5 = 5;
        cache.put((Object)key1, (Object)s1);
        cache.put((Object)key2, (Object)s2);
        cache.put((Object)key3, (Object)s3);
        cache.get((Object)key2);
        Assertions.assertEquals(LruCacheTest.set(key1, key2, key3), (Object)cache.keySet());
        Assertions.assertEquals((int)cache.maxSize(), (int)cache.size());
        cache.resize(5);
        Assertions.assertEquals((int)5, (int)cache.maxSize());
        Assertions.assertEquals((int)3, (int)cache.size());
        Assertions.assertTrue((boolean)cleaned.isEmpty());
        cache.put((Object)key4, (Object)s4);
        Assertions.assertEquals(LruCacheTest.set(key1, key2, key3, key4), (Object)cache.keySet());
        cache.put((Object)key5, (Object)s5);
        Assertions.assertEquals(LruCacheTest.set(key1, key2, key3, key4, key5), (Object)cache.keySet());
        Assertions.assertEquals((int)cache.maxSize(), (int)cache.size());
        cache.resize(4);
        Assertions.assertEquals(LruCacheTest.set(key2, key3, key4, key5), (Object)cache.keySet());
        Assertions.assertEquals((int)cache.maxSize(), (int)cache.size());
        Assertions.assertEquals(LruCacheTest.set(s1), cleaned);
        cleaned.clear();
        cache.resize(3);
        Assertions.assertEquals(LruCacheTest.set(key2, key4, key5), (Object)cache.keySet());
        Assertions.assertEquals((int)3, (int)cache.maxSize());
        Assertions.assertEquals((int)3, (int)cache.size());
        Assertions.assertEquals(LruCacheTest.set(s3), cleaned);
    }

    @Test
    void shouldClear() {
        final HashSet cleaned = new HashSet();
        LruCache<Integer, String> cache = new LruCache<Integer, String>("TestCache", 3){

            public void elementCleaned(String element) {
                cleaned.add(element);
            }
        };
        String s1 = "1";
        Integer key1 = 1;
        String s2 = "2";
        Integer key2 = 2;
        String s3 = "3";
        Integer key3 = 3;
        String s4 = "4";
        Integer key4 = 4;
        String s5 = "5";
        Integer key5 = 5;
        cache.put((Object)key1, (Object)s1);
        cache.put((Object)key2, (Object)s2);
        cache.put((Object)key3, (Object)s3);
        cache.get((Object)key2);
        Assertions.assertEquals(LruCacheTest.set(key1, key2, key3), (Object)cache.keySet());
        Assertions.assertEquals((int)cache.maxSize(), (int)cache.size());
        cache.resize(5);
        Assertions.assertEquals((int)5, (int)cache.maxSize());
        Assertions.assertEquals((int)3, (int)cache.size());
        cache.put((Object)key4, (Object)s4);
        Assertions.assertEquals(LruCacheTest.set(key1, key2, key3, key4), (Object)cache.keySet());
        cache.put((Object)key5, (Object)s5);
        Assertions.assertEquals(LruCacheTest.set(key1, key2, key3, key4, key5), (Object)cache.keySet());
        Assertions.assertEquals((int)cache.maxSize(), (int)cache.size());
        cache.clear();
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals(LruCacheTest.set(s1, s2, s3, s4, s5), cleaned);
    }

    private static <E> Set<E> set(E ... elems) {
        return new HashSet<E>(Arrays.asList(elems));
    }
}

