/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.collection.ExceptionHandlingIterable;
import org.neo4j.helpers.collection.Iterables;

class ExceptionHandlingIterableTest {
    ExceptionHandlingIterableTest() {
    }

    @Test
    void testHandleExceptionOnIteratorCreation() {
        Assertions.assertThrows(IllegalStateException.class, () -> Iterables.count((Iterable)new ExceptionHandlingIterable(() -> {
            throw new RuntimeException("exception on iterator");
        }){

            protected Iterator exceptionOnIterator(Throwable t) {
                this.rethrow(new IllegalStateException());
                return super.exceptionOnIterator(t);
            }
        }));
    }

    @Test
    void testHandleExceptionOnNext() {
        Assertions.assertThrows(IllegalStateException.class, () -> Iterables.count((Iterable)new ExceptionHandlingIterable(() -> new Iterator(){

            @Override
            public boolean hasNext() {
                return true;
            }

            public Object next() {
                throw new RuntimeException("exception on next");
            }

            @Override
            public void remove() {
            }
        }){

            protected Object exceptionOnNext(Throwable t) {
                this.rethrow(new IllegalStateException());
                return super.exceptionOnNext(t);
            }
        }));
    }

    @Test
    void testHandleExceptionOnHasNext() {
        Assertions.assertThrows(IllegalStateException.class, () -> Iterables.count((Iterable)new ExceptionHandlingIterable(() -> new Iterator(){

            @Override
            public boolean hasNext() {
                throw new RuntimeException("exception on next");
            }

            public Object next() {
                return null;
            }

            @Override
            public void remove() {
            }
        }){

            protected boolean exceptionOnHasNext(Throwable t) {
                this.rethrow(new IllegalStateException());
                return super.exceptionOnHasNext(t);
            }
        }));
    }
}

