/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;

class PrimitiveLongCollectionsTest {
    PrimitiveLongCollectionsTest() {
    }

    @Test
    void arrayOfItemsAsIterator() {
        long[] items = new long[]{2L, 5L, 234L};
        LongIterator iterator = PrimitiveLongCollections.iterator((long[])items);
        this.assertItems(iterator, items);
    }

    @Test
    void filter() {
        LongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        LongIterator filtered = PrimitiveLongCollections.filter((LongIterator)items, item -> item != 2L);
        this.assertItems(filtered, 1L, 3L);
    }

    @Test
    void indexOf() {
        Supplier<LongIterator> items = () -> PrimitiveLongCollections.iterator((long[])new long[]{10L, 20L, 30L});
        Assertions.assertEquals((int)-1, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)55L));
        Assertions.assertEquals((int)0, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)10L));
        Assertions.assertEquals((int)1, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)20L));
        Assertions.assertEquals((int)2, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)30L));
    }

    @Test
    void count() {
        LongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        int count = PrimitiveLongCollections.count((LongIterator)items);
        Assertions.assertEquals((int)3, (int)count);
    }

    @Test
    void asArray() {
        LongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        long[] array = PrimitiveLongCollections.asArray((LongIterator)items);
        Assertions.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L}, array));
    }

    @Test
    void shouldDeduplicate() {
        long[] array = new long[]{1L, 1L, 2L, 5L, 6L, 6L};
        long[] deduped = PrimitiveLongCollections.deduplicate((long[])array);
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 5L, 6L}, (long[])deduped);
    }

    @Test
    void shouldNotContinueToCallNextOnHasNextFalse() {
        final AtomicLong count = new AtomicLong(2L);
        PrimitiveLongCollections.PrimitiveLongBaseIterator iterator = new PrimitiveLongCollections.PrimitiveLongBaseIterator(){

            protected boolean fetchNext() {
                return count.decrementAndGet() >= 0L && this.next(count.get());
            }
        };
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((long)1L, (long)iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((long)0L, (long)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertEquals((long)-1L, (long)count.get());
    }

    @Test
    void convertJavaCollectionToSetOfPrimitives() {
        List<Long> longs = Arrays.asList(1L, 4L, 7L);
        MutableLongSet longSet = PrimitiveLongCollections.asSet(longs);
        Assertions.assertTrue((boolean)longSet.contains(1L));
        Assertions.assertTrue((boolean)longSet.contains(4L));
        Assertions.assertTrue((boolean)longSet.contains(7L));
        Assertions.assertEquals((int)3, (int)longSet.size());
    }

    @Test
    void convertPrimitiveSetToJavaSet() {
        LongHashSet longSet = LongHashSet.newSetWith((long[])new long[]{1L, 3L, 5L});
        Set longs = PrimitiveLongCollections.toSet((LongSet)longSet);
        MatcherAssert.assertThat((Object)longs, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 3L, 5L}));
    }

    @Test
    void mergeLongIterableToSet() {
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)new LongHashSet(), (LongIterable)new LongHashSet()), (Matcher)Matchers.equalTo((Object)new LongHashSet()));
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L}), (LongIterable)new LongHashSet()), (Matcher)Matchers.equalTo((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L})));
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L}), (LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L})), (Matcher)Matchers.equalTo((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L})));
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L}), (LongIterable)LongHashSet.newSetWith((long[])new long[]{4L, 5L, 6L})), (Matcher)Matchers.equalTo((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L})));
    }

    private void assertNoMoreItems(LongIterator iterator) {
        Assertions.assertFalse((boolean)iterator.hasNext(), (String)(iterator + " should have no more items"));
        try {
            iterator.next();
            Assertions.fail((String)("Invoking next() on " + iterator + " which has no items left should have thrown NoSuchElementException"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void assertNextEquals(long expected, LongIterator iterator) {
        Assertions.assertTrue((boolean)iterator.hasNext(), (String)(iterator + " should have had more items"));
        Assertions.assertEquals((long)expected, (long)iterator.next());
    }

    private void assertItems(LongIterator iterator, long ... expectedItems) {
        for (long expectedItem : expectedItems) {
            this.assertNextEquals(expectedItem, iterator);
        }
        this.assertNoMoreItems(iterator);
    }

    private static final class CountingPrimitiveLongIteratorResource
    implements LongIterator,
    AutoCloseable {
        private final LongIterator delegate;
        private final AtomicInteger closeCounter;

        private CountingPrimitiveLongIteratorResource(LongIterator delegate, AtomicInteger closeCounter) {
            this.delegate = delegate;
            this.closeCounter = closeCounter;
        }

        @Override
        public void close() {
            this.closeCounter.incrementAndGet();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public long next() {
            return this.delegate.next();
        }
    }
}

