/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongArrayQueue;

class PrimitiveLongArrayQueueTest {
    PrimitiveLongArrayQueueTest() {
    }

    @Test
    void newQueueIsEmpty() {
        Assertions.assertTrue((boolean)this.createQueue().isEmpty());
    }

    @Test
    void growQueueOnElementOffer() {
        PrimitiveLongArrayQueue longArrayQueue = this.createQueue();
        for (int i = 1; i < 1000; ++i) {
            longArrayQueue.enqueue((long)i);
            Assertions.assertEquals((int)i, (int)longArrayQueue.size());
        }
    }

    @Test
    void addRemoveElementKeepQueueEmpty() {
        PrimitiveLongArrayQueue longArrayQueue = this.createQueue();
        for (int i = 0; i < 1000; ++i) {
            longArrayQueue.enqueue((long)i);
            Assertions.assertEquals((long)i, (long)longArrayQueue.dequeue());
            Assertions.assertTrue((boolean)longArrayQueue.isEmpty());
        }
    }

    @Test
    void offerLessThenQueueCapacityElements() {
        PrimitiveLongArrayQueue arrayQueue = this.createQueue();
        for (int i = 1; i < 16; ++i) {
            arrayQueue.enqueue((long)i);
            Assertions.assertEquals((int)i, (int)arrayQueue.size());
        }
    }

    @Test
    void failToRemoveElementFromNewEmptyQueue() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.createQueue().dequeue());
    }

    @Test
    void offerMoreThenQueueCapacityElements() {
        PrimitiveLongArrayQueue arrayQueue = this.createQueue();
        for (int i = 1; i < 1234; ++i) {
            arrayQueue.enqueue((long)i);
        }
        int currentValue = 1;
        while (!arrayQueue.isEmpty()) {
            Assertions.assertEquals((long)currentValue++, (long)arrayQueue.dequeue());
        }
    }

    @Test
    void emptyQueueAfterClear() {
        PrimitiveLongArrayQueue queue = this.createQueue();
        queue.enqueue(2L);
        queue.enqueue(3L);
        Assertions.assertFalse((boolean)queue.isEmpty());
        Assertions.assertEquals((int)2, (int)queue.size());
        queue.clear();
        Assertions.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    void tailBeforeHeadCorrectSize() {
        int i;
        PrimitiveLongArrayQueue queue = this.createQueue();
        for (i = 0; i < 14; ++i) {
            queue.enqueue((long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((long)i, (long)queue.dequeue());
        }
        for (i = 14; i < 24; ++i) {
            queue.enqueue((long)i);
        }
        Assertions.assertEquals((int)14, (int)queue.size());
    }

    @Test
    void tailBeforeHeadCorrectResize() {
        int i;
        PrimitiveLongArrayQueue queue = this.createQueue();
        for (i = 0; i < 14; ++i) {
            queue.enqueue((long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((long)i, (long)queue.dequeue());
        }
        for (i = 14; i < 34; ++i) {
            queue.enqueue((long)i);
        }
        Assertions.assertEquals((int)24, (int)queue.size());
        for (int j = 10; j < 34; ++j) {
            Assertions.assertEquals((long)j, (long)queue.dequeue());
        }
    }

    @Test
    void tailBeforeHeadCorrectIteration() {
        int i;
        PrimitiveLongArrayQueue queue = this.createQueue();
        for (i = 0; i < 14; ++i) {
            queue.enqueue((long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((long)i, (long)queue.dequeue());
        }
        for (i = 14; i < 24; ++i) {
            queue.enqueue((long)i);
        }
        Assertions.assertEquals((int)14, (int)queue.size());
        LongIterator iterator = queue.longIterator();
        for (int j = 10; j < 24; ++j) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertEquals((long)j, (long)iterator.next());
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void failToGetNextOnEmptyQueueIterator() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.createQueue().longIterator().next());
    }

    @Test
    void addAllElementsFromOtherQueue() {
        PrimitiveLongArrayQueue queue = this.createQueue();
        queue.enqueue(1L);
        queue.enqueue(2L);
        PrimitiveLongArrayQueue otherQueue = this.createQueue();
        otherQueue.enqueue(3L);
        otherQueue.enqueue(4L);
        queue.addAll(otherQueue);
        Assertions.assertTrue((boolean)otherQueue.isEmpty());
        Assertions.assertEquals((int)0, (int)otherQueue.size());
        Assertions.assertEquals((int)4, (int)queue.size());
        for (int value = 1; value <= 4; ++value) {
            Assertions.assertEquals((long)value, (long)queue.dequeue());
        }
        Assertions.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    void doNotAllowCreationOfQueueWithRandomCapacity() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PrimitiveLongArrayQueue(7));
    }

    private PrimitiveLongArrayQueue createQueue() {
        return new PrimitiveLongArrayQueue();
    }
}

