/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveArrays;

class PrimitiveArraysTest {
    private static final int[] NO_INTS = new int[0];
    private static final int[] ONE_INT = new int[]{1};
    private static final long[] NO_LONGS = new long[0];
    private static final long[] ONE_LONG = new long[]{1L};

    PrimitiveArraysTest() {
    }

    @Test
    void union_shouldHandleNullInput() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.union(null, null), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)PrimitiveArrays.union(null, (int[])NO_INTS), (Matcher)Matchers.equalTo((Object)NO_INTS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.union((int[])NO_INTS, null), (Matcher)Matchers.equalTo((Object)NO_INTS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.union(null, (int[])ONE_INT), (Matcher)Matchers.equalTo((Object)ONE_INT));
        MatcherAssert.assertThat((Object)PrimitiveArrays.union((int[])ONE_INT, null), (Matcher)Matchers.equalTo((Object)ONE_INT));
    }

    @Test
    void intersect_shouldHandleNullInput() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect(null, null), (Matcher)Matchers.equalTo((Object)NO_LONGS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect(null, (long[])NO_LONGS), (Matcher)Matchers.equalTo((Object)NO_LONGS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])NO_LONGS, null), (Matcher)Matchers.equalTo((Object)NO_LONGS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect(null, (long[])ONE_LONG), (Matcher)Matchers.equalTo((Object)NO_LONGS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])ONE_LONG, null), (Matcher)Matchers.equalTo((Object)NO_LONGS));
    }

    @Test
    void intersect_shouldHandleNonIntersectingArrays() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{4L, 5L, 6L}), (Matcher)Matchers.equalTo((Object)NO_LONGS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])new long[]{14L, 15L, 16L}, (long[])new long[]{1L, 2L, 3L}), (Matcher)Matchers.equalTo((Object)NO_LONGS));
    }

    @Test
    void intersect_shouldHandleIntersectingArrays() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L, 4L, 5L}), PrimitiveArraysTest.isArray(3L));
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])new long[]{3L, 4L, 5L}, (long[])new long[]{1L, 2L, 3L, 4L}), PrimitiveArraysTest.isArray(3L, 4L));
    }

    @Test
    void intersect_shouldHandleComplexIntersectingArraysWithGaps() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}, (long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L}), PrimitiveArraysTest.isArray(4L, 9L, 12L));
        MatcherAssert.assertThat((Object)PrimitiveArrays.intersect((long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L}, (long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}), PrimitiveArraysTest.isArray(4L, 9L, 12L));
    }

    @Test
    void symDiff_shouldHandleNullInput() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference(null, null), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference(null, (long[])NO_LONGS), (Matcher)Matchers.equalTo((Object)NO_LONGS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])NO_LONGS, null), (Matcher)Matchers.equalTo((Object)NO_LONGS));
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference(null, (long[])ONE_LONG), (Matcher)Matchers.equalTo((Object)ONE_LONG));
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])ONE_LONG, null), (Matcher)Matchers.equalTo((Object)ONE_LONG));
    }

    @Test
    void symDiff_shouldHandleNonIntersectingArrays() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{4L, 5L, 6L}), PrimitiveArraysTest.isArray(1L, 2L, 3L, 4L, 5L, 6L));
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])new long[]{14L, 15L, 16L}, (long[])new long[]{1L, 2L, 3L}), PrimitiveArraysTest.isArray(1L, 2L, 3L, 14L, 15L, 16L));
    }

    @Test
    void symDiff_shouldHandleIntersectingArrays() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L, 4L, 5L}), PrimitiveArraysTest.isArray(1L, 2L, 4L, 5L));
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])new long[]{3L, 4L, 5L}, (long[])new long[]{1L, 2L, 3L, 4L}), PrimitiveArraysTest.isArray(1L, 2L, 5L));
    }

    @Test
    void symDiff_shouldHandleComplexIntersectingArraysWithGaps() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}, (long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L}), PrimitiveArraysTest.isArray(2L, 3L, 6L, 7L, 8L, 11L, 15L, 16L, 19L));
        MatcherAssert.assertThat((Object)PrimitiveArrays.symmetricDifference((long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L}, (long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}), PrimitiveArraysTest.isArray(2L, 3L, 6L, 7L, 8L, 11L, 15L, 16L, 19L));
    }

    @Test
    void shouldCountUnique() {
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{4L, 5L, 6L}), this.isIntPair(3, 3));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L, 6L}), this.isIntPair(2, 1));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L}), this.isIntPair(2, 0));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[]{3L}, (long[])new long[]{1L, 2L, 3L}), this.isIntPair(0, 2));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[]{3L}, (long[])new long[]{3L}), this.isIntPair(0, 0));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[]{3L, 6L, 8L}, (long[])new long[0]), this.isIntPair(3, 0));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[0], (long[])new long[]{3L, 6L, 8L}), this.isIntPair(0, 3));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[0], (long[])new long[0]), this.isIntPair(0, 0));
        MatcherAssert.assertThat((Object)PrimitiveArrays.countUnique((long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}, (long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L}), this.isIntPair(3, 6));
    }

    private Matcher<Long> isIntPair(final int left, final int right) {
        return new BaseMatcher<Long>(){

            public void describeTo(Description description) {
                description.appendValue((Object)left);
                description.appendValue((Object)right);
            }

            public boolean matches(Object o) {
                return o instanceof Long && (Long)o == ((long)left << 32 | (long)right);
            }
        };
    }

    private static Matcher<long[]> isArray(long ... values) {
        return Matchers.equalTo((Object)values);
    }
}

