/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.FirstItemIterable;

public class FirstItemIterableTest {
    @Test
    public void testEmptyIterator() throws Exception {
        FirstItemIterable firstItemIterable = new FirstItemIterable(Collections.emptyList());
        Iterator empty = firstItemIterable.iterator();
        Assert.assertEquals((Object)false, (Object)empty.hasNext());
        try {
            empty.next();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NoSuchElementException.class));
        }
        Assert.assertEquals(null, (Object)firstItemIterable.getFirst());
    }

    @Test
    public void testSingleIterator() throws Exception {
        FirstItemIterable firstItemIterable = new FirstItemIterable(Collections.singleton(Boolean.TRUE));
        Iterator empty = firstItemIterable.iterator();
        Assert.assertEquals((Object)true, (Object)empty.hasNext());
        Assert.assertEquals((Object)Boolean.TRUE, empty.next());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
        Assert.assertEquals((Object)false, (Object)empty.hasNext());
        try {
            empty.next();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NoSuchElementException.class));
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
    }

    @Test
    public void testMultiIterator() throws Exception {
        FirstItemIterable firstItemIterable = new FirstItemIterable(Arrays.asList(Boolean.TRUE, Boolean.FALSE));
        Iterator empty = firstItemIterable.iterator();
        Assert.assertEquals((Object)true, (Object)empty.hasNext());
        Assert.assertEquals((Object)Boolean.TRUE, empty.next());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
        Assert.assertEquals((Object)true, (Object)empty.hasNext());
        Assert.assertEquals((Object)Boolean.FALSE, empty.next());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
        Assert.assertEquals((Object)false, (Object)empty.hasNext());
        try {
            empty.next();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NoSuchElementException.class));
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
    }
}

