/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TypeReference {
    private final String packageName;
    private final String name;
    private final TypeReference[] parameters;
    private final boolean isPrimitive;
    private final boolean isArray;
    private final boolean isTypeParameter;
    private final String declaringClassName;
    private final int modifiers;
    public static final TypeReference VOID = new TypeReference("", "void", true, false, false, "", Void.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference OBJECT = new TypeReference("java.lang", "Object", false, false, false, "", Object.class.getModifiers(), new TypeReference[0]);
    public static final TypeReference BOOLEAN = new TypeReference("", "boolean", true, false, false, "", Boolean.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference INT = new TypeReference("", "int", true, false, false, "", Integer.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference LONG = new TypeReference("", "long", true, false, false, "", Long.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference DOUBLE = new TypeReference("", "double", true, false, false, "", Double.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference BOOLEAN_ARRAY = new TypeReference("", "boolean", false, true, false, "", Boolean.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference INT_ARRAY = new TypeReference("", "int", false, true, false, "", Integer.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference LONG_ARRAY = new TypeReference("", "long", false, true, false, "", Long.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference DOUBLE_ARRAY = new TypeReference("", "double", false, true, false, "", Double.TYPE.getModifiers(), new TypeReference[0]);
    static final TypeReference[] NO_TYPES = new TypeReference[0];

    public static Bound extending(Class<?> type) {
        return TypeReference.extending(TypeReference.typeReference(type));
    }

    public static Bound extending(final TypeReference type) {
        return new Bound(type){

            @Override
            public TypeReference extendsBound() {
                return type;
            }

            @Override
            public TypeReference superBound() {
                return null;
            }
        };
    }

    public static TypeReference typeReference(Class<?> type) {
        String name;
        Class<?> innerType;
        if (type == Void.TYPE) {
            return VOID;
        }
        if (type == Object.class) {
            return OBJECT;
        }
        String packageName = "";
        String declaringClassName = "";
        Class<?> clazz = innerType = type.isArray() ? type.getComponentType() : type;
        if (innerType.isPrimitive()) {
            switch (name = innerType.getName()) {
                case "boolean": {
                    return type.isArray() ? BOOLEAN_ARRAY : BOOLEAN;
                }
                case "int": {
                    return type.isArray() ? INT_ARRAY : INT;
                }
                case "long": {
                    return type.isArray() ? LONG_ARRAY : LONG;
                }
                case "double": {
                    return type.isArray() ? DOUBLE_ARRAY : DOUBLE;
                }
            }
        } else {
            packageName = innerType.getPackage().getName();
            String canonicalName = innerType.getCanonicalName();
            Class<?> declaringClass = innerType.getDeclaringClass();
            if (declaringClass != null) {
                declaringClassName = declaringClass.getSimpleName();
                name = canonicalName.substring(packageName.length() + declaringClassName.length() + 2);
            } else {
                name = canonicalName.substring(packageName.length() + 1);
            }
        }
        return new TypeReference(packageName, name, type.isPrimitive(), type.isArray(), false, declaringClassName, type.getModifiers(), new TypeReference[0]);
    }

    public static TypeReference typeParameter(String name) {
        return new TypeReference("", name, false, false, true, "", 1, new TypeReference[0]);
    }

    public static TypeReference arrayOf(TypeReference type) {
        return new TypeReference(type.packageName, type.name, false, true, false, type.declaringClassName, type.modifiers, new TypeReference[0]);
    }

    public static TypeReference parameterizedType(Class<?> base, Class<?> ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), TypeReference.typeReferences(parameters));
    }

    public static TypeReference parameterizedType(Class<?> base, TypeReference ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), parameters);
    }

    public static TypeReference parameterizedType(TypeReference base, TypeReference ... parameters) {
        return new TypeReference(base.packageName, base.name, false, base.isArray(), false, base.declaringClassName, base.modifiers, parameters);
    }

    public static TypeReference[] typeReferences(Class<?> first, Class<?>[] more) {
        TypeReference[] result = new TypeReference[more.length + 1];
        result[0] = TypeReference.typeReference(first);
        for (int i = 0; i < more.length; ++i) {
            result[i + 1] = TypeReference.typeReference(more[i]);
        }
        return result;
    }

    public static TypeReference[] typeReferences(Class<?>[] types) {
        TypeReference[] result = new TypeReference[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TypeReference.typeReference(types[i]);
        }
        return result;
    }

    TypeReference(String packageName, String name, boolean isPrimitive, boolean isArray, boolean isTypeParameter, String declaringClassName, int modifiers, TypeReference ... parameters) {
        this.packageName = packageName;
        this.name = name;
        this.isPrimitive = isPrimitive;
        this.isArray = isArray;
        this.isTypeParameter = isTypeParameter;
        this.declaringClassName = declaringClassName;
        this.modifiers = modifiers;
        this.parameters = parameters;
    }

    public String packageName() {
        return this.packageName;
    }

    public String name() {
        return this.name;
    }

    public String simpleName() {
        return this.isArray ? this.name + "[]" : this.name;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isTypeParameter() {
        return this.isTypeParameter;
    }

    public boolean isGeneric() {
        return this.parameters == null || this.parameters.length > 0;
    }

    public List<TypeReference> parameters() {
        return Collections.unmodifiableList(Arrays.asList(this.parameters));
    }

    public String fullName() {
        return this.writeTo(new StringBuilder()).toString();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isVoid() {
        return this == VOID;
    }

    public boolean isInnerClass() {
        return !this.declaringClassName.isEmpty();
    }

    public String declaringClassName() {
        return this.declaringClassName;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeReference reference = (TypeReference)o;
        if (this.isPrimitive != reference.isPrimitive) {
            return false;
        }
        if (this.isArray != reference.isArray) {
            return false;
        }
        if (this.isTypeParameter != reference.isTypeParameter) {
            return false;
        }
        if (this.modifiers != reference.modifiers) {
            return false;
        }
        if (this.packageName != null ? !this.packageName.equals(reference.packageName) : reference.packageName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(reference.name) : reference.name != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, reference.parameters)) {
            return false;
        }
        return this.declaringClassName != null ? this.declaringClassName.equals(reference.declaringClassName) : reference.declaringClassName == null;
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + (this.isPrimitive ? 1 : 0);
        result = 31 * result + (this.isArray ? 1 : 0);
        result = 31 * result + (this.isTypeParameter ? 1 : 0);
        result = 31 * result + (this.declaringClassName != null ? this.declaringClassName.hashCode() : 0);
        result = 31 * result + this.modifiers;
        return result;
    }

    public String toString() {
        return this.writeTo(new StringBuilder().append("TypeReference[")).append(']').toString();
    }

    StringBuilder writeTo(StringBuilder result) {
        if (!this.packageName.isEmpty()) {
            result.append(this.packageName).append('.');
        }
        if (!this.declaringClassName.isEmpty()) {
            result.append(this.declaringClassName).append('.');
        }
        result.append(this.name);
        if (this.isArray) {
            result.append("[]");
        }
        if (this.parameters != null && this.parameters.length != 0) {
            result.append('<');
            String sep = "";
            for (TypeReference parameter : this.parameters) {
                parameter.writeTo(result.append(sep));
                sep = ",";
            }
            result.append('>');
        }
        return result;
    }

    public static abstract class Bound {
        private final TypeReference type;

        private Bound(TypeReference type) {
            this.type = type;
        }

        public abstract TypeReference extendsBound();

        public abstract TypeReference superBound();
    }
}

