/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.MethodReference;

public class ExpressionTest {
    @Test
    public void shouldNegateTrueToFalse() throws Exception {
        Assert.assertSame((Object)Expression.FALSE, (Object)Expression.not((Expression)Expression.TRUE));
        Assert.assertSame((Object)Expression.TRUE, (Object)Expression.not((Expression)Expression.FALSE));
    }

    @Test
    public void shouldRemoveDoubleNegation() throws Exception {
        Expression expression = Expression.invoke((MethodReference)MethodReference.methodReference(this.getClass(), Boolean.TYPE, (String)"TRUE", (Class[])new Class[0]), (Expression[])new Expression[0]);
        Assert.assertSame((Object)expression, (Object)Expression.not((Expression)Expression.not((Expression)expression)));
    }

    @Test
    public void shouldOptimizeNullChecks() throws Exception {
        ExpressionVisitor visitor = (ExpressionVisitor)Mockito.mock(ExpressionVisitor.class);
        Expression expression = Expression.invoke((MethodReference)MethodReference.methodReference(this.getClass(), Object.class, (String)"value", (Class[])new Class[0]), (Expression[])new Expression[0]);
        Expression.equal((Expression)expression, (Expression)Expression.NULL).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).isNull(expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.equal((Expression)Expression.NULL, (Expression)expression).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).isNull(expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.not((Expression)Expression.equal((Expression)expression, (Expression)Expression.NULL)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).notNull(expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.not((Expression)Expression.equal((Expression)Expression.NULL, (Expression)expression)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).notNull(expression);
    }

    @Test
    public void shouldOptimizeNegatedInequalities() throws Exception {
        ExpressionVisitor visitor = (ExpressionVisitor)Mockito.mock(ExpressionVisitor.class);
        Expression expression = Expression.invoke((MethodReference)MethodReference.methodReference(this.getClass(), Object.class, (String)"value", (Class[])new Class[0]), (Expression[])new Expression[0]);
        Expression.not((Expression)Expression.gt((Expression)expression, (Expression)expression)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).lte(expression, expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.not((Expression)Expression.gte((Expression)expression, (Expression)expression)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).lt(expression, expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.not((Expression)Expression.lt((Expression)expression, (Expression)expression)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).gte(expression, expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.not((Expression)Expression.lte((Expression)expression, (Expression)expression)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).gt(expression, expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.not((Expression)Expression.equal((Expression)expression, (Expression)expression)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).notEqual(expression, expression);
        Mockito.reset((Object[])new ExpressionVisitor[]{visitor});
        Expression.not((Expression)Expression.notEqual((Expression)expression, (Expression)expression)).accept(visitor);
        ((ExpressionVisitor)Mockito.verify((Object)visitor)).equal(expression, expression);
    }

    @Test
    public void shouldOptimizeBooleanCombinationsWithConstants() throws Exception {
        Expression expression = Expression.invoke((MethodReference)MethodReference.methodReference(this.getClass(), Boolean.TYPE, (String)"TRUE", (Class[])new Class[0]), (Expression[])new Expression[0]);
        Assert.assertSame((Object)expression, (Object)Expression.and((Expression)expression, (Expression)Expression.TRUE));
        Assert.assertSame((Object)expression, (Object)Expression.and((Expression)Expression.TRUE, (Expression)expression));
        Assert.assertSame((Object)Expression.FALSE, (Object)Expression.and((Expression)expression, (Expression)Expression.FALSE));
        Assert.assertSame((Object)Expression.FALSE, (Object)Expression.and((Expression)Expression.FALSE, (Expression)expression));
        Assert.assertSame((Object)expression, (Object)Expression.or((Expression)expression, (Expression)Expression.FALSE));
        Assert.assertSame((Object)expression, (Object)Expression.or((Expression)Expression.FALSE, (Expression)expression));
        Assert.assertSame((Object)Expression.TRUE, (Object)Expression.or((Expression)expression, (Expression)Expression.TRUE));
        Assert.assertSame((Object)Expression.TRUE, (Object)Expression.or((Expression)Expression.TRUE, (Expression)expression));
    }

    public static boolean TRUE() {
        return true;
    }

    public static Object value() {
        return null;
    }
}

