/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import co.unruly.matchers.OptionalMatchers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.strategies.ConnectToRandomCoreServerStrategyTest;
import org.neo4j.causalclustering.upstream.strategies.UserDefinedConfigurationStrategy;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class UserDefinedConfigurationStrategyTest {
    private final String northGroup = "north";
    private final String southGroup = "south";
    private final String westGroup = "west";
    private final String eastGroup = "east";
    private final List<String> noEastGroup = Arrays.asList("north", "south", "west");

    @Test
    public void shouldPickTheFirstMatchingServerIfCore() {
        MemberId theCoreMemberId = new MemberId(UUID.randomUUID());
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(theCoreMemberId), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(UserDefinedConfigurationStrategyTest.memberIDs(100), this::noEastGroupGenerator));
        UserDefinedConfigurationStrategy strategy = new UserDefinedConfigurationStrategy();
        Config config = Config.defaults((Setting)CausalClusteringSettings.user_defined_upstream_selection_strategy, (String)"groups(east); groups(core); halt()");
        strategy.inject(topologyService, config, (LogProvider)NullLogProvider.getInstance(), null);
        Optional memberId = strategy.upstreamDatabase();
        Assert.assertThat((Object)memberId, (Matcher)OptionalMatchers.contains((Object)theCoreMemberId));
    }

    @Test
    public void shouldPickTheFirstMatchingServerIfReadReplica() {
        Object[] readReplicaIds = UserDefinedConfigurationStrategyTest.memberIDs(100);
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(new MemberId(UUID.randomUUID())), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology((MemberId[])readReplicaIds, this::noEastGroupGenerator));
        UserDefinedConfigurationStrategy strategy = new UserDefinedConfigurationStrategy();
        String wantedGroup = this.noEastGroup.get(1);
        Config config = this.configWithFilter("groups(" + wantedGroup + "); halt()");
        strategy.inject(topologyService, config, (LogProvider)NullLogProvider.getInstance(), null);
        Optional memberId = strategy.upstreamDatabase();
        Assert.assertThat((Object)memberId, (Matcher)OptionalMatchers.contains((Matcher)Matchers.isIn((Object[])readReplicaIds)));
        Assert.assertThat(memberId.map(this::noEastGroupGenerator), (Matcher)OptionalMatchers.contains((Matcher)Matchers.equalTo((Object)Iterators.asSet((Object[])new String[]{wantedGroup}))));
    }

    @Test
    public void shouldReturnEmptyIfNoMatchingServers() {
        MemberId[] readReplicaIds = UserDefinedConfigurationStrategyTest.memberIDs(100);
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(new MemberId(UUID.randomUUID())), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(readReplicaIds, this::noEastGroupGenerator));
        UserDefinedConfigurationStrategy strategy = new UserDefinedConfigurationStrategy();
        String wantedGroup = "east";
        Config config = this.configWithFilter("groups(" + wantedGroup + "); halt()");
        strategy.inject(topologyService, config, (LogProvider)NullLogProvider.getInstance(), null);
        Optional memberId = strategy.upstreamDatabase();
        Assert.assertThat((Object)memberId, (Matcher)OptionalMatchers.empty());
    }

    @Test
    public void shouldReturnEmptyIfInvalidFilterSpecification() {
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(new MemberId(UUID.randomUUID())), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(UserDefinedConfigurationStrategyTest.memberIDs(100), this::noEastGroupGenerator));
        UserDefinedConfigurationStrategy strategy = new UserDefinedConfigurationStrategy();
        Config config = this.configWithFilter("invalid filter specification");
        strategy.inject(topologyService, config, (LogProvider)NullLogProvider.getInstance(), null);
        Optional memberId = strategy.upstreamDatabase();
        Assert.assertThat((Object)memberId, (Matcher)OptionalMatchers.empty());
    }

    @Test
    public void shouldNotReturnSelf() {
        String wantedGroup = "east";
        MemberId[] readReplicaIds = UserDefinedConfigurationStrategyTest.memberIDs(1);
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(new MemberId(UUID.randomUUID())), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(readReplicaIds, (MemberId memberId) -> Iterators.asSet((Object[])new String[]{wantedGroup})));
        UserDefinedConfigurationStrategy strategy = new UserDefinedConfigurationStrategy();
        Config config = this.configWithFilter("groups(" + wantedGroup + "); halt()");
        strategy.inject(topologyService, config, (LogProvider)NullLogProvider.getInstance(), readReplicaIds[0]);
        Optional memberId2 = strategy.upstreamDatabase();
        Assert.assertThat((Object)memberId2, (Matcher)OptionalMatchers.empty());
    }

    private Config configWithFilter(String filter) {
        return Config.defaults((Setting)CausalClusteringSettings.user_defined_upstream_selection_strategy, (String)filter);
    }

    static ReadReplicaTopology fakeReadReplicaTopology(MemberId ... readReplicaIds) {
        return UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(readReplicaIds, (MemberId ignored) -> Collections.emptySet());
    }

    static ReadReplicaTopology fakeReadReplicaTopology(MemberId[] readReplicaIds, Function<MemberId, Set<String>> groupGenerator) {
        assert (readReplicaIds.length > 0);
        AtomicInteger offset = new AtomicInteger(10000);
        Function<MemberId, ReadReplicaInfo> toReadReplicaInfo = memberId -> UserDefinedConfigurationStrategyTest.readReplicaInfo(memberId, offset, groupGenerator);
        Map readReplicas = Stream.of(readReplicaIds).collect(Collectors.toMap(Function.identity(), toReadReplicaInfo));
        return new ReadReplicaTopology(readReplicas);
    }

    private static ReadReplicaInfo readReplicaInfo(MemberId memberId, AtomicInteger offset, Function<MemberId, Set<String>> groupGenerator) {
        return new ReadReplicaInfo(new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("localhost", offset.getAndIncrement())))), new AdvertisedSocketAddress("localhost", offset.getAndIncrement()), groupGenerator.apply(memberId), "default");
    }

    static TopologyService fakeTopologyService(final CoreTopology coreTopology, final ReadReplicaTopology readReplicaTopology) {
        return new TopologyService(){
            private Map<MemberId, AdvertisedSocketAddress> catchupAddresses;
            {
                this.catchupAddresses = HazelcastClusterTopology.extractCatchupAddressesMap((CoreTopology)coreTopology, (ReadReplicaTopology)readReplicaTopology);
            }

            public CoreTopology allCoreServers() {
                return coreTopology;
            }

            public CoreTopology localCoreServers() {
                return coreTopology;
            }

            public ReadReplicaTopology allReadReplicas() {
                return readReplicaTopology;
            }

            public ReadReplicaTopology localReadReplicas() {
                return readReplicaTopology;
            }

            public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
                return Optional.ofNullable(this.catchupAddresses.get(upstream));
            }

            public Map<MemberId, RoleInfo> allCoreRoles() {
                return Collections.emptyMap();
            }

            public MemberId myself() {
                return new MemberId(new UUID(0L, 0L));
            }

            public String localDBName() {
                return "default";
            }

            public void init() throws Throwable {
            }

            public void start() throws Throwable {
            }

            public void stop() throws Throwable {
            }

            public void shutdown() throws Throwable {
            }
        };
    }

    static MemberId[] memberIDs(int howMany) {
        return (MemberId[])Stream.generate(() -> new MemberId(UUID.randomUUID())).limit(howMany).toArray(MemberId[]::new);
    }

    private Set<String> noEastGroupGenerator(MemberId memberId) {
        int index = Math.abs(memberId.hashCode()) % this.noEastGroup.size();
        return Iterators.asSet((Object[])new String[]{this.noEastGroup.get(index)});
    }
}

