/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.strategies.ConnectToRandomCoreServerStrategyTest;
import org.neo4j.causalclustering.upstream.strategies.TopologyServiceThatPrioritisesItself;
import org.neo4j.causalclustering.upstream.strategies.TypicallyConnectToRandomReadReplicaStrategy;
import org.neo4j.causalclustering.upstream.strategies.UserDefinedConfigurationStrategyTest;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class TypicallyConnectToRandomReadReplicaStrategyTest {
    MemberId myself = new MemberId(new UUID(1234L, 5678L));

    @Test
    public void shouldConnectToCoreOneInTenTimesByDefault() {
        MemberId theCoreMemberId = new MemberId(UUID.randomUUID());
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(theCoreMemberId), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(UserDefinedConfigurationStrategyTest.memberIDs(100)));
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.get(CausalClusteringSettings.database)).thenReturn((Object)"default");
        TypicallyConnectToRandomReadReplicaStrategy connectionStrategy = new TypicallyConnectToRandomReadReplicaStrategy(2);
        connectionStrategy.inject(topologyService, config, (LogProvider)NullLogProvider.getInstance(), this.myself);
        ArrayList responses = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                responses.add(connectionStrategy.upstreamDatabase().get());
            }
            Assert.assertThat(responses, (Matcher)CoreMatchers.hasItem((Object)theCoreMemberId));
            responses.clear();
        }
    }

    @Test
    public void filtersSelf() {
        String groupName = "groupName";
        Config config = Config.defaults();
        TypicallyConnectToRandomReadReplicaStrategy typicallyConnectToRandomReadReplicaStrategy = new TypicallyConnectToRandomReadReplicaStrategy();
        typicallyConnectToRandomReadReplicaStrategy.inject((TopologyService)new TopologyServiceThatPrioritisesItself(this.myself, groupName), config, (LogProvider)NullLogProvider.getInstance(), this.myself);
        Optional found = typicallyConnectToRandomReadReplicaStrategy.upstreamDatabase();
        Assert.assertTrue((boolean)found.isPresent());
        Assert.assertNotEquals((Object)this.myself, (Object)found);
    }

    @Test
    public void onCounterTriggerFiltersSelf() {
        TypicallyConnectToRandomReadReplicaStrategy connectionStrategy = new TypicallyConnectToRandomReadReplicaStrategy(1);
        MemberId otherCoreMember = new MemberId(new UUID(12L, 34L));
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(this.myself, otherCoreMember), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(UserDefinedConfigurationStrategyTest.memberIDs(2)));
        connectionStrategy.inject(topologyService, Config.defaults(), (LogProvider)NullLogProvider.getInstance(), this.myself);
        Optional found = connectionStrategy.upstreamDatabase();
        Assert.assertTrue((boolean)found.isPresent());
        Assert.assertNotEquals((Object)this.myself, found.get());
    }

    @Test
    public void randomCoreDoesNotReturnSameCoreTwice() {
        TypicallyConnectToRandomReadReplicaStrategy connectionStrategy = new TypicallyConnectToRandomReadReplicaStrategy(1);
        MemberId firstOther = new MemberId(new UUID(12L, 34L));
        MemberId secondOther = new MemberId(new UUID(56L, 78L));
        TopologyService topologyService = UserDefinedConfigurationStrategyTest.fakeTopologyService(ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(this.myself, firstOther, secondOther), UserDefinedConfigurationStrategyTest.fakeReadReplicaTopology(UserDefinedConfigurationStrategyTest.memberIDs(2)));
        connectionStrategy.inject(topologyService, Config.defaults(), (LogProvider)NullLogProvider.getInstance(), this.myself);
        List found = IntStream.range(0, 20).mapToObj(i -> connectionStrategy.upstreamDatabase()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Assert.assertFalse((boolean)found.contains(this.myself));
        Assert.assertTrue((boolean)found.contains(firstOther));
        Assert.assertTrue((boolean)found.contains(secondOther));
    }
}

