/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;

class TopologyServiceThatPrioritisesItself
implements TopologyService {
    private final MemberId myself;
    private final String matchingGroupName;
    MemberId coreNotSelf = new MemberId(new UUID(321L, 654L));
    MemberId readReplicaNotSelf = new MemberId(new UUID(432L, 543L));

    TopologyServiceThatPrioritisesItself(MemberId myself, String matchingGroupName) {
        this.myself = myself;
        this.matchingGroupName = matchingGroupName;
    }

    public String localDBName() {
        throw new RuntimeException("Unimplemented");
    }

    public CoreTopology allCoreServers() {
        boolean canBeBootstrapped = true;
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        coreMembers.put(this.myself, TopologyServiceThatPrioritisesItself.coreServerInfo(new String[0]));
        coreMembers.put(this.coreNotSelf, TopologyServiceThatPrioritisesItself.coreServerInfo(new String[0]));
        return new CoreTopology(new ClusterId(new UUID(99L, 88L)), canBeBootstrapped, coreMembers);
    }

    public CoreTopology localCoreServers() {
        return this.allCoreServers();
    }

    public ReadReplicaTopology allReadReplicas() {
        HashMap<MemberId, ReadReplicaInfo> readReplicaMembers = new HashMap<MemberId, ReadReplicaInfo>();
        readReplicaMembers.put(this.myself, TopologyServiceThatPrioritisesItself.readReplicaInfo(this.matchingGroupName));
        readReplicaMembers.put(this.readReplicaNotSelf, TopologyServiceThatPrioritisesItself.readReplicaInfo(this.matchingGroupName));
        return new ReadReplicaTopology(readReplicaMembers);
    }

    public ReadReplicaTopology localReadReplicas() {
        return this.allReadReplicas();
    }

    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
        throw new RuntimeException("Unimplemented");
    }

    public Map<MemberId, RoleInfo> allCoreRoles() {
        throw new RuntimeException("Unimplemented");
    }

    public MemberId myself() {
        return this.myself;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }

    private static CoreServerInfo coreServerInfo(String ... groupNames) {
        AdvertisedSocketAddress anyRaftAddress = new AdvertisedSocketAddress("hostname", 1234);
        AdvertisedSocketAddress anyCatchupServer = new AdvertisedSocketAddress("hostname", 5678);
        ClientConnectorAddresses clientConnectorAddress = new ClientConnectorAddresses(Collections.emptyList());
        HashSet<String> groups = new HashSet<String>(Arrays.asList(groupNames));
        return new CoreServerInfo(anyRaftAddress, anyCatchupServer, clientConnectorAddress, groups, "dbName", false);
    }

    private static ReadReplicaInfo readReplicaInfo(String ... groupNames) {
        ClientConnectorAddresses clientConnectorAddresses = new ClientConnectorAddresses(Collections.emptyList());
        AdvertisedSocketAddress catchupServerAddress = new AdvertisedSocketAddress("hostname", 2468);
        HashSet<String> groups = new HashSet<String>(Arrays.asList(groupNames));
        ReadReplicaInfo readReplicaInfo = new ReadReplicaInfo(clientConnectorAddresses, catchupServerAddress, groups, "dbName");
        return readReplicaInfo;
    }
}

