/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.helpers.DataCreator;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.PageCacheRule;

public class TransactionLogRecoveryIT {
    @Rule
    public final PageCacheRule pageCache = new PageCacheRule();
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(3);
    private Cluster<?> cluster;
    private FileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void coreShouldStartAfterPartialTransactionWriteCrash() throws Exception {
        Cluster.dataMatchesEventually(DataCreator.createEmptyNodes(this.cluster, 10), this.cluster.coreMembers());
        CoreClusterMember core = this.cluster.getCoreMemberById(0);
        core.shutdown();
        CoreClusterMember lastWrites = DataCreator.createEmptyNodes(this.cluster, 10);
        this.writePartialTx(core.databaseDirectory());
        core.start();
        Cluster.dataMatchesEventually(lastWrites, Collections.singletonList(core));
    }

    @Test
    public void coreShouldStartWithSeedHavingPartialTransactionWriteCrash() throws Exception {
        Cluster.dataMatchesEventually(DataCreator.createEmptyNodes(this.cluster, 10), this.cluster.coreMembers());
        CoreClusterMember core = this.cluster.getCoreMemberById(0);
        core.shutdown();
        CoreClusterMember lastWrites = DataCreator.createEmptyNodes(this.cluster, 10);
        this.writePartialTx(core.databaseDirectory());
        this.fs.deleteRecursively(core.clusterStateDirectory());
        core.start();
        Cluster.dataMatchesEventually(lastWrites, Collections.singletonList(core));
    }

    @Test
    public void readReplicaShouldStartAfterPartialTransactionWriteCrash() throws Exception {
        Cluster.dataMatchesEventually(DataCreator.createEmptyNodes(this.cluster, 10), this.cluster.readReplicas());
        ReadReplica readReplica = this.cluster.getReadReplicaById(0);
        readReplica.shutdown();
        CoreClusterMember lastWrites = DataCreator.createEmptyNodes(this.cluster, 10);
        Cluster.dataMatchesEventually(lastWrites, this.cluster.coreMembers());
        this.writePartialTx(readReplica.databaseDirectory());
        readReplica.start();
        Cluster.dataMatchesEventually(lastWrites, Collections.singletonList(readReplica));
    }

    private void writePartialTx(File storeDir) throws IOException {
        try (PageCache pageCache = this.pageCache.getPageCache(this.fs);){
            LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)DatabaseLayout.of((File)storeDir), (FileSystemAbstraction)this.fs, (PageCache)pageCache).build();
            try (Lifespan ignored = new Lifespan(new Lifecycle[]{logFiles});){
                LogEntryWriter writer = new LogEntryWriter((WritableChannel)logFiles.getLogFile().getWriter());
                writer.writeStartEntry(0, 0, 81985529216486895L, logFiles.getLogFileInformation().getLastEntryId() + 1L, new byte[]{0});
            }
        }
    }
}

