/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.EnterpriseCluster;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingResult;
import org.neo4j.causalclustering.routing.load_balancing.procedure.ParameterNames;
import org.neo4j.causalclustering.routing.load_balancing.procedure.ProcedureNames;
import org.neo4j.causalclustering.routing.load_balancing.procedure.ResultFormatV1;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseLoginContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ServerPoliciesLoadBalancingIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private Cluster<?> cluster;

    @After
    public void after() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void defaultBehaviour() throws Exception {
        this.cluster = new EnterpriseCluster(this.testDir.directory("cluster"), 3, 3, (DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "standard", IpFamily.IPV4, false);
        this.cluster.start();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(3, 1, 2, 3));
    }

    @Test
    public void defaultBehaviourWithAllowReadsOnFollowers() throws Exception {
        this.cluster = new EnterpriseCluster(this.testDir.directory("cluster"), 3, 3, (DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory(), (Map<String, String>)MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.cluster_allow_reads_on_followers.name(), "true"}), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "standard", IpFamily.IPV4, false);
        this.cluster.start();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(3, 1, 2, 3));
    }

    @Test
    public void shouldFallOverBetweenRules() throws Exception {
        HashMap<String, IntFunction<String>> instanceCoreParams = new HashMap<String, IntFunction<String>>();
        instanceCoreParams.put(CausalClusteringSettings.server_groups.name(), id -> "core" + id + ",core");
        HashMap<String, IntFunction<String>> instanceReplicaParams = new HashMap<String, IntFunction<String>>();
        instanceReplicaParams.put(CausalClusteringSettings.server_groups.name(), id -> "replica" + id + ",replica");
        String defaultPolicy = "groups(core) -> min(3); groups(replica1,replica2) -> min(2);";
        Map coreParams = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.cluster_allow_reads_on_followers.name(), "true", CausalClusteringSettings.load_balancing_config.name() + ".server_policies.default", defaultPolicy, CausalClusteringSettings.multi_dc_license.name(), "true"});
        this.cluster = new EnterpriseCluster(this.testDir.directory("cluster"), 5, 5, (DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory(), (Map<String, String>)coreParams, (Map<String, IntFunction<String>>)instanceCoreParams, Collections.emptyMap(), (Map<String, IntFunction<String>>)instanceReplicaParams, "standard", IpFamily.IPV4, false);
        this.cluster.start();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(5, 1, 4, 0));
        this.cluster.getCoreMemberById(3).shutdown();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(4, 1, 3, 0));
        this.cluster.getCoreMemberById(0).shutdown();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(3, 1, 0, 2));
        this.cluster.getReadReplicaById(0).shutdown();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(3, 1, 0, 2));
        this.cluster.getReadReplicaById(1).shutdown();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(3, 1, 2, 3));
        this.cluster.addCoreMemberWithId(3).start();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(4, 1, 3, 0));
    }

    @Test
    public void shouldSupportSeveralPolicies() throws Exception {
        HashMap<String, IntFunction<String>> instanceCoreParams = new HashMap<String, IntFunction<String>>();
        instanceCoreParams.put(CausalClusteringSettings.server_groups.name(), id -> "core" + id + ",core");
        HashMap<String, IntFunction<String>> instanceReplicaParams = new HashMap<String, IntFunction<String>>();
        instanceReplicaParams.put(CausalClusteringSettings.server_groups.name(), id -> "replica" + id + ",replica");
        String defaultPolicySpec = "groups(replica0,replica1)";
        String policyOneTwoSpec = "groups(replica1,replica2)";
        String policyZeroTwoSpec = "groups(replica0,replica2)";
        String policyAllReplicasSpec = "groups(replica); halt()";
        String allPolicySpec = "all()";
        Map coreParams = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.cluster_allow_reads_on_followers.name(), "true", CausalClusteringSettings.load_balancing_config.name() + ".server_policies.all", allPolicySpec, CausalClusteringSettings.load_balancing_config.name() + ".server_policies.default", defaultPolicySpec, CausalClusteringSettings.load_balancing_config.name() + ".server_policies.policy_one_two", policyOneTwoSpec, CausalClusteringSettings.load_balancing_config.name() + ".server_policies.policy_zero_two", policyZeroTwoSpec, CausalClusteringSettings.load_balancing_config.name() + ".server_policies.policy_all_replicas", policyAllReplicasSpec, CausalClusteringSettings.multi_dc_license.name(), "true"});
        this.cluster = new EnterpriseCluster(this.testDir.directory("cluster"), 3, 3, (DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory(), (Map<String, String>)coreParams, (Map<String, IntFunction<String>>)instanceCoreParams, Collections.emptyMap(), (Map<String, IntFunction<String>>)instanceReplicaParams, "standard", IpFamily.IPV4, false);
        this.cluster.start();
        this.assertGetServersEventuallyMatchesOnAllCores((Matcher<LoadBalancingResult>)new CountsMatcher(3, 1, 2, 3), this.policyContext("all"));
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            CoreGraphDatabase db = core.database();
            Assert.assertThat((Object)this.getServers(db, this.policyContext("default")), (Matcher)new SpecificReplicasMatcher(0, 1));
            Assert.assertThat((Object)this.getServers(db, this.policyContext("policy_one_two")), (Matcher)new SpecificReplicasMatcher(1, 2));
            Assert.assertThat((Object)this.getServers(db, this.policyContext("policy_zero_two")), (Matcher)new SpecificReplicasMatcher(0, 2));
            Assert.assertThat((Object)this.getServers(db, this.policyContext("policy_all_replicas")), (Matcher)new SpecificReplicasMatcher(0, 1, 2));
        }
    }

    private Map<String, String> policyContext(String policyName) {
        return MapUtil.stringMap((String[])new String[]{"policy", policyName});
    }

    private void assertGetServersEventuallyMatchesOnAllCores(Matcher<LoadBalancingResult> matcher) throws InterruptedException {
        this.assertGetServersEventuallyMatchesOnAllCores(matcher, Collections.emptyMap());
    }

    private void assertGetServersEventuallyMatchesOnAllCores(Matcher<LoadBalancingResult> matcher, Map<String, String> context) throws InterruptedException {
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            if (core.database() == null) continue;
            ServerPoliciesLoadBalancingIT.assertEventually(matcher, () -> this.getServers(core.database(), context));
        }
    }

    private LoadBalancingResult getServers(CoreGraphDatabase db, Map<String, String> context) {
        LoadBalancingResult lbResult = null;
        try (InternalTransaction tx = db.beginTransaction(Transaction.Type.explicit, (LoginContext)EnterpriseLoginContext.AUTH_DISABLED);){
            Map parameters = MapUtil.map((Object[])new Object[]{ParameterNames.CONTEXT.parameterName(), context});
            try (Result result = db.execute(tx, "CALL " + ProcedureNames.GET_SERVERS_V2.callName(), ValueUtils.asMapValue((Map)parameters));){
                while (result.hasNext()) {
                    lbResult = ResultFormatV1.parse((Map)result.next());
                }
            }
        }
        return lbResult;
    }

    private static <T, E extends Exception> void assertEventually(Matcher<? super T> matcher, ThrowingSupplier<T, E> actual) throws InterruptedException, E {
        org.neo4j.test.assertion.Assert.assertEventually((String)"", actual, matcher, (long)120L, (TimeUnit)TimeUnit.SECONDS);
    }

    class SpecificReplicasMatcher
    extends BaseMatcher<LoadBalancingResult> {
        private final Set<Integer> replicaIds;

        SpecificReplicasMatcher(Integer ... replicaIds) {
            this.replicaIds = Arrays.stream(replicaIds).collect(Collectors.toSet());
        }

        public boolean matches(Object item) {
            LoadBalancingResult result = (LoadBalancingResult)item;
            Set returnedReaders = result.readEndpoints().stream().map(Endpoint::address).collect(Collectors.toSet());
            Set expectedBolts = ServerPoliciesLoadBalancingIT.this.cluster.readReplicas().stream().filter(r -> this.replicaIds.contains(r.serverId())).map(r -> r.clientConnectorAddresses().boltAddress()).collect(Collectors.toSet());
            return expectedBolts.equals(returnedReaders);
        }

        public void describeTo(Description description) {
            description.appendText("replicaIds=" + this.replicaIds);
        }
    }

    class CountsMatcher
    extends BaseMatcher<LoadBalancingResult> {
        private final int nRouters;
        private final int nWriters;
        private final int nCoreReaders;
        private final int nReplicaReaders;

        CountsMatcher(int nRouters, int nWriters, int nCoreReaders, int nReplicaReaders) {
            this.nRouters = nRouters;
            this.nWriters = nWriters;
            this.nCoreReaders = nCoreReaders;
            this.nReplicaReaders = nReplicaReaders;
        }

        public boolean matches(Object item) {
            LoadBalancingResult result = (LoadBalancingResult)item;
            if (result.routeEndpoints().size() != this.nRouters || result.writeEndpoints().size() != this.nWriters) {
                return false;
            }
            Set allCoreBolts = ServerPoliciesLoadBalancingIT.this.cluster.coreMembers().stream().map(c -> c.clientConnectorAddresses().boltAddress()).collect(Collectors.toSet());
            Set returnedCoreReaders = result.readEndpoints().stream().map(Endpoint::address).filter(allCoreBolts::contains).collect(Collectors.toSet());
            if (returnedCoreReaders.size() != this.nCoreReaders) {
                return false;
            }
            Set allReplicaBolts = ServerPoliciesLoadBalancingIT.this.cluster.readReplicas().stream().map(c -> c.clientConnectorAddresses().boltAddress()).collect(Collectors.toSet());
            Set returnedReplicaReaders = result.readEndpoints().stream().map(Endpoint::address).filter(allReplicaBolts::contains).collect(Collectors.toSet());
            if (returnedReplicaReaders.size() != this.nReplicaReaders) {
                return false;
            }
            HashSet overlap = new HashSet(returnedCoreReaders);
            overlap.retainAll(returnedReplicaReaders);
            if (!overlap.isEmpty()) {
                return false;
            }
            Set returnedWriters = result.writeEndpoints().stream().map(Endpoint::address).collect(Collectors.toSet());
            if (!allCoreBolts.containsAll(returnedWriters)) {
                return false;
            }
            Set returnedRouters = result.routeEndpoints().stream().map(Endpoint::address).collect(Collectors.toSet());
            return allCoreBolts.containsAll(returnedRouters);
        }

        public void describeTo(Description description) {
            description.appendText("nRouters=" + this.nRouters);
            description.appendText(", nWriters=" + this.nWriters);
            description.appendText(", nCoreReaders=" + this.nCoreReaders);
            description.appendText(", nReplicaReaders=" + this.nReplicaReaders);
        }
    }
}

