/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.test.causalclustering.ClusterRule;

public class ReadReplicaStoreCopyIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withSharedCoreParam(GraphDatabaseSettings.keep_logical_logs, "false").withNumberOfCoreMembers(3).withNumberOfReadReplicas(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=240000L)
    public void shouldNotBePossibleToStartTransactionsWhenReadReplicaCopiesStore() throws Throwable {
        Cluster<?> cluster = this.clusterRule.startCluster();
        ReadReplica readReplica = cluster.findAnyReadReplica();
        readReplica.txPollingClient().stop();
        ReadReplicaStoreCopyIT.writeSomeDataAndForceLogRotations(cluster);
        Semaphore storeCopyBlockingSemaphore = ReadReplicaStoreCopyIT.addStoreCopyBlockingMonitor(readReplica);
        try {
            readReplica.txPollingClient().start();
            ReadReplicaStoreCopyIT.waitForStoreCopyToStartAndBlock(storeCopyBlockingSemaphore);
            ReadReplicaGraphDatabase replicaGraphDatabase = readReplica.database();
            try {
                replicaGraphDatabase.beginTx();
                Assert.fail((String)"Exception expected");
            }
            catch (Exception e) {
                Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionFailureException.class));
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Database is stopped to copy store"));
            }
        }
        finally {
            storeCopyBlockingSemaphore.release(Integer.MAX_VALUE);
        }
    }

    private static void writeSomeDataAndForceLogRotations(Cluster<?> cluster) throws Exception {
        for (int i = 0; i < 20; ++i) {
            cluster.coreTx((db, tx) -> {
                db.execute("CREATE ()");
                tx.success();
            });
            ReadReplicaStoreCopyIT.forceLogRotationOnAllCores(cluster);
        }
    }

    private static void forceLogRotationOnAllCores(Cluster<?> cluster) {
        for (CoreClusterMember core : cluster.coreMembers()) {
            ReadReplicaStoreCopyIT.forceLogRotationAndPruning(core);
        }
    }

    private static void forceLogRotationAndPruning(CoreClusterMember core) {
        try {
            DependencyResolver dependencyResolver = core.database().getDependencyResolver();
            ((LogRotation)dependencyResolver.resolveDependency(LogRotation.class)).rotateLogFile();
            SimpleTriggerInfo info = new SimpleTriggerInfo("test");
            ((CheckPointer)dependencyResolver.resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)info);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Semaphore addStoreCopyBlockingMonitor(ReadReplica readReplica) {
        Semaphore semaphore = new Semaphore(0);
        readReplica.monitors().addMonitorListener(file -> {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }, new String[0]);
        return semaphore;
    }

    private static void waitForStoreCopyToStartAndBlock(Semaphore storeCopyBlockingSemaphore) throws Exception {
        org.neo4j.test.assertion.Assert.assertEventually((String)"Read replica did not copy files", storeCopyBlockingSemaphore::hasQueuedThreads, (Matcher)Matchers.is((Object)true), (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }
}

