/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

public class InstalledProtocolsProcedureIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withSharedCoreParam(CausalClusteringSettings.leader_election_timeout, "2s").withSharedCoreParam(CausalClusteringSettings.compression_implementations, "snappy").withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    private Cluster<?> cluster;
    private CoreClusterMember leader;

    @Before
    public void startUp() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        this.leader = this.cluster.awaitLeader();
    }

    @Test
    public void shouldSeeOutboundInstalledProtocolsOnLeader() throws Throwable {
        String modifiers = new StringJoiner(",", "[", "]").add(Protocol.ModifierProtocols.COMPRESSION_SNAPPY.implementation()).toString();
        Object[] expectedProtocolInfos = (ProtocolInfo[])this.cluster.coreMembers().stream().filter(member -> !member.equals(this.leader)).map(member -> new ProtocolInfo("outbound", this.localhost(member.raftListenAddress()), Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), 2L, modifiers)).toArray(ProtocolInfo[]::new);
        Assert.assertEventually((String)("should see outbound installed protocols on core " + this.leader.serverId()), () -> this.installedProtocols((GraphDatabaseFacade)this.leader.database(), "outbound"), (Matcher)Matchers.hasItems((Object[])expectedProtocolInfos), (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldSeeInboundInstalledProtocolsOnLeader() throws Throwable {
        Assert.assertEventually((String)("should see inbound installed protocols on core " + this.leader.serverId()), () -> this.installedProtocols((GraphDatabaseFacade)this.leader.database(), "inbound"), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(this.cluster.coreMembers().size() - 1))), (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    private List<ProtocolInfo> installedProtocols(GraphDatabaseFacade db, String wantedOrientation) throws TransactionFailureException, ProcedureException {
        LinkedList<ProtocolInfo> infos = new LinkedList<ProtocolInfo>();
        Kernel kernel = (Kernel)db.getDependencyResolver().resolveDependency(Kernel.class);
        try (Transaction tx = kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            RawIterator itr = tx.procedures().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"dbms", "cluster", "protocols"}), null);
            while (itr.hasNext()) {
                Object[] row = (Object[])itr.next();
                String orientation = (String)row[0];
                String address = this.localhost((String)row[1]);
                String protocol = (String)row[2];
                long version = (Long)row[3];
                String modifiers = (String)row[4];
                if (!orientation.equals(wantedOrientation)) continue;
                infos.add(new ProtocolInfo(orientation, address, protocol, version, modifiers));
            }
            LinkedList<ProtocolInfo> linkedList = infos;
            return linkedList;
        }
    }

    private String localhost(String uri) {
        return uri.replace("127.0.0.1", "localhost");
    }

    private static class ProtocolInfo {
        private final String orientation;
        private final String address;
        private final String protocol;
        private final long version;
        private final String modifiers;

        private ProtocolInfo(String orientation, String address, String protocol, long version, String modifiers) {
            this.orientation = orientation;
            this.address = address;
            this.protocol = protocol;
            this.version = version;
            this.modifiers = modifiers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProtocolInfo that = (ProtocolInfo)o;
            return this.version == that.version && Objects.equals(this.orientation, that.orientation) && Objects.equals(this.address, that.address) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.modifiers, that.modifiers);
        }

        public int hashCode() {
            return Objects.hash(this.orientation, this.address, this.protocol, this.version, this.modifiers);
        }

        public String toString() {
            return "ProtocolInfo{orientation='" + this.orientation + '\'' + ", address='" + this.address + '\'' + ", protocol='" + this.protocol + '\'' + ", version=" + this.version + ", modifiers='" + this.modifiers + '\'' + '}';
        }
    }
}

