/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.helpers.DataCreator;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.graphdb.Label;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public class ClusterCompressionIT {
    @Parameterized.Parameter
    public Protocol.ModifierProtocol modifierProtocol;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(3).withTimeout(1000L, TimeUnit.SECONDS);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Protocol.ModifierProtocol> params() {
        return Arrays.asList(Protocol.ModifierProtocols.values());
    }

    @Test
    public void shouldReplicateWithCompression() throws Exception {
        this.clusterRule.withSharedCoreParam(CausalClusteringSettings.compression_implementations, (String)((Object)this.modifierProtocol.implementation())).withSharedReadReplicaParam(CausalClusteringSettings.compression_implementations, (String)((Object)this.modifierProtocol.implementation()));
        Cluster<?> cluster = this.clusterRule.startCluster();
        int numberOfNodes = 10;
        CoreClusterMember leader = DataCreator.createLabelledNodesWithProperty(cluster, numberOfNodes, Label.label((String)"Foo"), () -> Pair.of((Object)"foobar", (Object)String.format("baz_bat%s", UUID.randomUUID())));
        Assert.assertEquals((long)numberOfNodes, (long)DataCreator.countNodes(leader));
        Cluster.dataMatchesEventually(leader, cluster.coreMembers());
    }
}

