/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.TestStoreId;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.state.storage.SimpleFileStorage;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.scenarios.SampleData;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ClusterBindingIT {
    private final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withSharedCoreParam(CausalClusteringSettings.raft_log_pruning_strategy, "3 entries").withSharedCoreParam(CausalClusteringSettings.raft_log_rotation_size, "1K");
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.clusterRule);
    private Cluster<?> cluster;
    private FileSystemAbstraction fs;

    @Before
    public void setup() throws Exception {
        this.fs = this.fileSystemRule.get();
        this.cluster = this.clusterRule.startCluster();
        this.cluster.coreTx((db, tx) -> {
            SampleData.createSchema((GraphDatabaseService)db);
            tx.success();
        });
    }

    @Test
    public void allServersShouldHaveTheSameStoreId() throws Throwable {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        List<File> coreStoreDirs = ClusterBindingIT.databaseDirs(this.cluster.coreMembers());
        this.cluster.shutdown();
        TestStoreId.assertAllStoresHaveTheSameStoreId(coreStoreDirs, this.fs);
    }

    @Test
    public void whenWeRestartTheClusterAllServersShouldStillHaveTheSameStoreId() throws Throwable {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.shutdown();
        this.cluster.start();
        List<File> coreStoreDirs = ClusterBindingIT.databaseDirs(this.cluster.coreMembers());
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.shutdown();
        TestStoreId.assertAllStoresHaveTheSameStoreId(coreStoreDirs, this.fs);
    }

    @Test
    @Ignore(value="Fix this test by having the bootstrapper augment his store and bind it using store-id on disk.")
    public void shouldNotJoinClusterIfHasDataWithDifferentStoreId() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        File databaseDirectory = this.cluster.getCoreMemberById(0).databaseDirectory();
        this.cluster.removeCoreMemberWithServerId(0);
        this.changeStoreId(DatabaseLayout.of((File)databaseDirectory));
        try {
            this.cluster.addCoreMemberWithId(0).start();
            Assert.fail((String)"Should not have joined the cluster");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(LifecycleException.class));
        }
    }

    @Test
    public void laggingFollowerShouldDownloadSnapshot() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.removeCoreMemberWithServerId(0);
        SampleData.createSomeData(100, this.cluster);
        for (CoreClusterMember db2 : this.cluster.coreMembers()) {
            db2.raftLogPruner().prune();
        }
        this.cluster.addCoreMemberWithId(0).start();
        this.cluster.awaitLeader();
        Assert.assertEquals((long)3L, (long)this.cluster.healthyCoreMembers().size());
        List<File> coreStoreDirs = ClusterBindingIT.databaseDirs(this.cluster.coreMembers());
        this.cluster.shutdown();
        TestStoreId.assertAllStoresHaveTheSameStoreId(coreStoreDirs, this.fs);
    }

    @Test
    public void badFollowerShouldNotJoinCluster() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        CoreClusterMember coreMember = this.cluster.getCoreMemberById(0);
        this.cluster.removeCoreMemberWithServerId(0);
        this.changeClusterId(coreMember);
        SampleData.createSomeData(100, this.cluster);
        for (CoreClusterMember db2 : this.cluster.coreMembers()) {
            db2.raftLogPruner().prune();
        }
        try {
            this.cluster.addCoreMemberWithId(0).start();
            Assert.fail((String)"Should not have joined the cluster");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(LifecycleException.class));
        }
    }

    @Test
    public void aNewServerShouldJoinTheClusterByDownloadingASnapshot() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        SampleData.createSomeData(100, this.cluster);
        for (CoreClusterMember db2 : this.cluster.coreMembers()) {
            db2.raftLogPruner().prune();
        }
        this.cluster.addCoreMemberWithId(4).start();
        this.cluster.awaitLeader();
        Assert.assertEquals((long)4L, (long)this.cluster.healthyCoreMembers().size());
        List<File> coreStoreDirs = ClusterBindingIT.databaseDirs(this.cluster.coreMembers());
        this.cluster.shutdown();
        TestStoreId.assertAllStoresHaveTheSameStoreId(coreStoreDirs, this.fs);
    }

    private static List<File> databaseDirs(Collection<CoreClusterMember> dbs) {
        return dbs.stream().map(CoreClusterMember::databaseDirectory).collect(Collectors.toList());
    }

    private void changeClusterId(CoreClusterMember coreMember) throws IOException {
        SimpleFileStorage clusterIdStorage = new SimpleFileStorage(this.fs, coreMember.clusterStateDirectory(), "cluster-id", (ChannelMarshal)new ClusterId.Marshal(), (LogProvider)NullLogProvider.getInstance());
        clusterIdStorage.writeState((Object)new ClusterId(UUID.randomUUID()));
    }

    private void changeStoreId(DatabaseLayout databaseLayout) throws Exception {
        File neoStoreFile = databaseLayout.metadataStore();
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs, (JobScheduler)jobScheduler);){
            MetaDataStore.setRecord((PageCache)pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.RANDOM_NUMBER, (long)System.currentTimeMillis());
        }
    }
}

