/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.TestStoreId;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.helpers.DataCreator;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public abstract class BaseMultiClusteringIT {
    protected static Set<String> DB_NAMES_1 = Collections.singleton("default");
    protected static Set<String> DB_NAMES_2 = Stream.of("foo", "bar").collect(Collectors.toSet());
    protected static Set<String> DB_NAMES_3 = Stream.of("foo", "bar", "baz").collect(Collectors.toSet());
    private final Set<String> dbNames;
    private final ClusterRule clusterRule;
    private final DefaultFileSystemRule fileSystemRule;
    private final DiscoveryServiceType discoveryType;
    @Rule
    public final RuleChain ruleChain;
    private Cluster<?> cluster;
    private FileSystemAbstraction fs;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    protected BaseMultiClusteringIT(String ignoredName, int numCores, int numReplicas, Set<String> dbNames, DiscoveryServiceType discoveryServiceType) {
        this.dbNames = dbNames;
        this.discoveryType = discoveryServiceType;
        this.clusterRule = new ClusterRule().withNumberOfCoreMembers(numCores).withNumberOfReadReplicas(numReplicas).withDatabaseNames(dbNames);
        this.fileSystemRule = new DefaultFileSystemRule();
        this.ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.clusterRule);
    }

    @Before
    public void setup() throws Exception {
        this.clusterRule.withDiscoveryServiceType(this.discoveryType);
        this.fs = this.fileSystemRule.get();
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldRunDistinctTransactionsAndDiverge() throws Exception {
        int numNodes = 1;
        HashMap leaderMap = new HashMap();
        for (String dbName : this.dbNames) {
            CoreClusterMember leader;
            int i = 0;
            do {
                leader = this.cluster.coreTx(dbName, (db, tx) -> {
                    Node node = db.createNode(new Label[]{Label.label((String)"database")});
                    node.setProperty("name", (Object)dbName);
                    tx.success();
                });
            } while (++i < numNodes);
            int leaderId = leader.serverId();
            List notLeaders = this.cluster.coreMembers().stream().filter(m -> m.dbName().equals(dbName) && m.serverId() != leaderId).collect(Collectors.toList());
            leaderMap.put(leader, notLeaders);
            ++numNodes;
        }
        Set nodesPerDb = leaderMap.keySet().stream().map(DataCreator::countNodes).collect(Collectors.toSet());
        Assert.assertEquals((String)"Each logical database in the multicluster should have a unique number of nodes.", (long)nodesPerDb.size(), (long)this.dbNames.size());
        for (Map.Entry subCluster : leaderMap.entrySet()) {
            Cluster.dataMatchesEventually((ClusterMember)subCluster.getKey(), (Collection)subCluster.getValue());
        }
    }

    @Test
    public void distinctDatabasesShouldHaveDistinctStoreIds() throws Exception {
        for (String dbName : this.dbNames) {
            this.cluster.coreTx(dbName, (db, tx) -> {
                Node node = db.createNode(new Label[]{Label.label((String)"database")});
                node.setProperty("name", (Object)dbName);
                tx.success();
            });
        }
        List<File> storeDirs = this.cluster.coreMembers().stream().map(CoreClusterMember::databaseDirectory).collect(Collectors.toList());
        this.cluster.shutdown();
        Set<StoreId> storeIds = TestStoreId.getStoreIds(storeDirs, this.fs);
        int expectedNumStoreIds = this.dbNames.size();
        Assert.assertEquals((String)"Expected distinct store ids for distinct sub clusters.", (long)expectedNumStoreIds, (long)storeIds.size());
    }

    @Test
    public void rejoiningFollowerShouldDownloadSnapshotFromCorrectDatabase() throws Exception {
        String dbName = BaseMultiClusteringIT.getFirstDbName(this.dbNames);
        int followerId = this.cluster.getMemberWithAnyRole(dbName, Role.FOLLOWER).serverId();
        this.cluster.removeCoreMemberWithServerId(followerId);
        for (int i = 0; i < 100; ++i) {
            this.cluster.coreTx(dbName, (db, tx) -> {
                Node node = db.createNode(new Label[]{Label.label((String)(dbName + "Node"))});
                node.setProperty("name", (Object)dbName);
                tx.success();
            });
        }
        for (CoreClusterMember m2 : this.cluster.coreMembers()) {
            m2.raftLogPruner().prune();
        }
        this.cluster.addCoreMemberWithId(followerId).start();
        CoreClusterMember dbLeader = this.cluster.awaitLeader(dbName);
        boolean followerIsHealthy = this.cluster.healthyCoreMembers().stream().anyMatch(m -> m.serverId() == followerId);
        Assert.assertTrue((String)"Rejoining / lagging follower is expected to be healthy.", (boolean)followerIsHealthy);
        CoreClusterMember follower = this.cluster.getCoreMemberById(followerId);
        Cluster.dataMatchesEventually(dbLeader, Collections.singleton(follower));
        List<File> storeDirs = this.cluster.coreMembers().stream().filter(m -> dbName.equals(m.dbName())).map(CoreClusterMember::databaseDirectory).collect(Collectors.toList());
        this.cluster.shutdown();
        Set<StoreId> storeIds = TestStoreId.getStoreIds(storeDirs, this.fs);
        String message = "All members of a sub-cluster should have the same store Id after downloading a snapshot.";
        Assert.assertEquals((String)message, (long)1L, (long)storeIds.size());
    }

    @Test
    public void shouldNotBeAbleToChangeClusterMembersDatabaseName() throws Exception {
        CoreClusterMember member = this.cluster.coreMembers().stream().findFirst().orElseThrow(IllegalArgumentException::new);
        Cluster.shutdownCoreMember(member);
        member.updateConfig(CausalClusteringSettings.database, "new_name");
        try {
            Cluster.startCoreMember(member);
            Assert.fail((String)"Cluster member should fail to restart after database name change.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private static String getFirstDbName(Set<String> dbNames) throws Exception {
        return (String)dbNames.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("The dbNames parameter must not be empty."));
    }
}

