/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.routing.multi_cluster.MultiClusterRoutingResult;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.MultiClusterRoutingResultFormat;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.ParameterNames;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.ProcedureNames;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.enterprise.api.security.EnterpriseLoginContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public abstract class BaseMultiClusterRoutingIT {
    protected static Set<String> DB_NAMES_1 = Stream.of("foo", "bar").collect(Collectors.toSet());
    protected static Set<String> DB_NAMES_2 = Collections.singleton("default");
    protected static Set<String> DB_NAMES_3 = Stream.of("foo", "bar", "baz").collect(Collectors.toSet());
    private final Set<String> dbNames;
    private final ClusterRule clusterRule;
    private final DefaultFileSystemRule fileSystemRule;
    private final DiscoveryServiceType discoveryType;
    private final int numCores;
    private Cluster<?> cluster;
    private FileSystemAbstraction fs;
    @Rule
    public final RuleChain ruleChain;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    protected BaseMultiClusterRoutingIT(String ignoredName, int numCores, int numReplicas, Set<String> dbNames, DiscoveryServiceType discoveryType) {
        this.dbNames = dbNames;
        this.discoveryType = discoveryType;
        this.clusterRule = new ClusterRule().withNumberOfCoreMembers(numCores).withNumberOfReadReplicas(numReplicas).withDatabaseNames(dbNames);
        this.numCores = numCores;
        this.fileSystemRule = new DefaultFileSystemRule();
        this.ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.clusterRule);
    }

    @Before
    public void setup() throws Exception {
        this.clusterRule.withDiscoveryServiceType(this.discoveryType);
        this.fs = this.fileSystemRule.get();
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void superCallShouldReturnAllRouters() {
        List dbs = this.dbNames.stream().map(n -> this.cluster.getMemberWithAnyRole((String)n, Role.FOLLOWER, Role.LEADER).database()).collect(Collectors.toList());
        Stream<Optional> optResults = dbs.stream().map(db -> BaseMultiClusterRoutingIT.callProcedure(db, ProcedureNames.GET_ROUTERS_FOR_ALL_DATABASES, Collections.emptyMap()));
        List results = optResults.filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Assert.assertEquals((String)"There should be a result for each database against which the procedure is executed.", (long)this.dbNames.size(), (long)results.size());
        boolean consistentResults = results.stream().distinct().count() == 1L;
        MatcherAssert.assertThat((String)"The results should be the same, regardless of which database the procedure is executed against.", (boolean)consistentResults);
        Function<Map, Integer> countHosts = m -> m.values().stream().mapToInt(List::size).sum();
        int resultsAllCores = results.stream().findFirst().map(r -> (Integer)countHosts.apply(r.routers())).orElse(0);
        Assert.assertEquals((String)"The results of the procedure should return all core hosts in the topology.", (long)this.numCores, (long)resultsAllCores);
    }

    @Test
    public void subCallShouldReturnLocalRouters() {
        String dbName = BaseMultiClusterRoutingIT.getFirstDbName(this.dbNames);
        Stream<CoreGraphDatabase> members = this.dbNames.stream().map(n -> this.cluster.getMemberWithAnyRole((String)n, Role.FOLLOWER, Role.LEADER).database());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ParameterNames.DATABASE.parameterName(), dbName);
        Stream<Optional> optResults = members.map(db -> BaseMultiClusterRoutingIT.callProcedure(db, ProcedureNames.GET_ROUTERS_FOR_DATABASE, params));
        List results = optResults.filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        boolean consistentResults = results.stream().distinct().count() == 1L;
        MatcherAssert.assertThat((String)"The results should be the same, regardless of which database the procedure is executed against.", (boolean)consistentResults);
        Optional firstResult = results.stream().findFirst();
        int numRouterSets = firstResult.map(r -> r.routers().size()).orElse(0);
        Assert.assertEquals((String)"There should only be routers returned for a single database.", (long)1L, (long)numRouterSets);
        boolean correctResultDbName = firstResult.map(r -> r.routers().containsKey(dbName)).orElse(false);
        MatcherAssert.assertThat((String)"The results should contain routers for the database passed to the procedure.", (boolean)correctResultDbName);
    }

    @Test
    public void procedureCallsShouldReflectMembershipChanges() throws Exception {
        String dbName = BaseMultiClusterRoutingIT.getFirstDbName(this.dbNames);
        CoreClusterMember follower = this.cluster.getMemberWithAnyRole(dbName, Role.FOLLOWER);
        int followerId = follower.serverId();
        this.cluster.removeCoreMemberWithServerId(followerId);
        CoreGraphDatabase db = this.cluster.getMemberWithAnyRole(dbName, Role.FOLLOWER, Role.LEADER).database();
        Function<CoreGraphDatabase, Set> getResult = database -> {
            Optional<MultiClusterRoutingResult> optResult = BaseMultiClusterRoutingIT.callProcedure(database, ProcedureNames.GET_ROUTERS_FOR_ALL_DATABASES, Collections.emptyMap());
            return optResult.map(r -> r.routers().values().stream().flatMap(Collection::stream).collect(Collectors.toSet())).orElse(Collections.emptySet());
        };
        org.neo4j.test.assertion.Assert.assertEventually((String)"The procedure should return one fewer routers when a core member has been removed.", () -> ((Set)getResult.apply(db)).size(), (Matcher)Is.is((Object)(this.numCores - 1)), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        BiPredicate<Set, CoreClusterMember> containsFollower = (rs, f) -> rs.stream().anyMatch(r -> r.address().toString().equals(f.boltAdvertisedAddress()));
        org.neo4j.test.assertion.Assert.assertEventually((String)"The procedure should not return a host as a router after it has been removed from the cluster", () -> containsFollower.test((Set)getResult.apply(db), follower), (Matcher)Is.is((Object)false), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        CoreClusterMember newFollower = this.cluster.addCoreMemberWithId(followerId);
        newFollower.start();
        org.neo4j.test.assertion.Assert.assertEventually((String)"The procedure should return one more router when a core member has been added.", () -> ((Set)getResult.apply(db)).size(), (Matcher)Is.is((Object)this.numCores), (long)15L, (TimeUnit)TimeUnit.SECONDS);
        org.neo4j.test.assertion.Assert.assertEventually((String)"The procedure should return a core member as a router after it has been added to the cluster", () -> containsFollower.test((Set)getResult.apply(db), newFollower), (Matcher)Is.is((Object)true), (long)15L, (TimeUnit)TimeUnit.SECONDS);
    }

    private static String getFirstDbName(Set<String> dbNames) {
        return (String)dbNames.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("The dbNames parameter must not be empty."));
    }

    private static Optional<MultiClusterRoutingResult> callProcedure(CoreGraphDatabase db, ProcedureNames procedure, Map<String, Object> params) {
        Optional<MultiClusterRoutingResult> routingResult = Optional.empty();
        try (InternalTransaction tx = db.beginTransaction(Transaction.Type.explicit, (LoginContext)EnterpriseLoginContext.AUTH_DISABLED);
             Result result = db.execute(tx, "CALL " + procedure.callName(), ValueUtils.asMapValue(params));){
            if (result.hasNext()) {
                routingResult = Optional.of(MultiClusterRoutingResultFormat.parse((Map)result.next()));
            }
        }
        return routingResult;
    }
}

