/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.multi_cluster.procedure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.multi_cluster.MultiClusterRoutingResult;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.MultiClusterRoutingResultFormat;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class MultiClusterRoutingResultFormatTest {
    @Test
    public void shouldSerializeToAndFromRecordFormat() {
        List<Endpoint> fooRouters = Arrays.asList(Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("host1", 1)), Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("host2", 1)), Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("host3", 1)));
        List<Endpoint> barRouters = Arrays.asList(Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("host4", 1)), Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("host5", 1)), Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("host6", 1)));
        HashMap<String, List<Endpoint>> routers = new HashMap<String, List<Endpoint>>();
        routers.put("foo", fooRouters);
        routers.put("bar", barRouters);
        long ttlSeconds = 5L;
        MultiClusterRoutingResult original = new MultiClusterRoutingResult(routers, ttlSeconds * 1000L);
        Object[] record = MultiClusterRoutingResultFormat.build((MultiClusterRoutingResult)original);
        MultiClusterRoutingResult parsed = MultiClusterRoutingResultFormat.parse((Object[])record);
        Assert.assertEquals((Object)original, (Object)parsed);
    }
}

