/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.causalclustering.readreplica.EnterpriseReadReplicaEditionModule;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class EnterpriseReadReplicaEditionModuleTest {
    @Inject
    private TestDirectory testDirectory;

    EnterpriseReadReplicaEditionModuleTest() {
    }

    @Test
    void fileWatcherFileNameFilter() {
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        Predicate filter = EnterpriseReadReplicaEditionModule.fileWatcherFileNameFilter();
        String metadataStoreName = databaseLayout.metadataStore().getName();
        Assert.assertFalse((boolean)filter.test(metadataStoreName));
        Assert.assertFalse((boolean)filter.test(databaseLayout.nodeStore().getName()));
        Assert.assertTrue((boolean)filter.test("neostore.transaction.db.1"));
        Assert.assertTrue((boolean)filter.test("index.db.any"));
        Assert.assertTrue((boolean)filter.test("branched"));
        Assert.assertTrue((boolean)filter.test("temp-copy"));
        Assert.assertTrue((boolean)filter.test(metadataStoreName + ".cacheprof"));
    }
}

