/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.helpers.collection.Iterators;

public class SupportedProtocolsTest {
    @Test
    public void shouldMutuallySupportIntersectionOfParameterVersionsSuperset() {
        ApplicationSupportedProtocols supportedProtocols = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Arrays.asList(1, 2));
        Set mutuallySupported = supportedProtocols.mutuallySupportedVersionsFor(Iterators.asSet((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)mutuallySupported, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldMutuallySupportIntersectionOfParameterVersionsSubset() {
        ApplicationSupportedProtocols supportedProtocols = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Arrays.asList(4, 5, 6));
        Set mutuallySupported = supportedProtocols.mutuallySupportedVersionsFor(Iterators.asSet((Object[])new Integer[]{4, 5}));
        Assert.assertThat((Object)mutuallySupported, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{4, 5}));
    }

    @Test
    public void shouldMutuallySupportParameterIfEmptyVersions() {
        ApplicationSupportedProtocols supportedProtocols = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.emptyList());
        Set mutuallySupported = supportedProtocols.mutuallySupportedVersionsFor(Iterators.asSet((Object[])new Integer[]{7, 8}));
        Assert.assertThat((Object)mutuallySupported, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{7, 8}));
    }

    @Test
    public void shouldMutuallySupportNothingIfParametersEmpty() {
        ApplicationSupportedProtocols supportedProtocols = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Arrays.asList(1, 2));
        Set mutuallySupported = supportedProtocols.mutuallySupportedVersionsFor(Collections.emptySet());
        Assert.assertThat((Object)mutuallySupported, (Matcher)Matchers.empty());
    }
}

