/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.helpers.Buffers;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.BoundedNetworkWritableChannel;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

@RunWith(value=Parameterized.class)
public class CoreReplicatedContentMarshallingTest {
    @Rule
    public final Buffers buffers = new Buffers();
    @Parameterized.Parameter
    public ReplicatedContent replicatedContent;

    @Parameterized.Parameters(name="{0}")
    public static ReplicatedContent[] data() {
        return new ReplicatedContent[]{new DummyRequest(new byte[]{1, 2, 3}), ReplicatedTransaction.from((byte[])new byte[16384]), new MemberIdSet((Set)new HashSet<MemberId>(){
            {
                this.add(new MemberId(UUID.randomUUID()));
            }
        }), new ReplicatedTokenRequest(TokenType.LABEL, "token", new byte[]{99, 111, 5}), new NewLeaderBarrier(), new ReplicatedLockTokenRequest(new MemberId(UUID.randomUUID()), 2), new DistributedOperation((ReplicatedContent)new DistributedOperation((ReplicatedContent)ReplicatedTransaction.from((byte[])new byte[]{1, 2, 3, 4, 5, 6}), new GlobalSession(UUID.randomUUID(), new MemberId(UUID.randomUUID())), new LocalOperationId(1L, 2L)), new GlobalSession(UUID.randomUUID(), new MemberId(UUID.randomUUID())), new LocalOperationId(4L, 5L))};
    }

    @Test
    public void shouldSerializeAndDeserialize() throws Exception {
        SafeChannelMarshal coreReplicatedContentMarshal = CoreReplicatedContentMarshal.marshaller();
        ByteBuf buffer = this.buffers.buffer();
        BoundedNetworkWritableChannel channel = new BoundedNetworkWritableChannel(buffer);
        coreReplicatedContentMarshal.marshal((Object)this.replicatedContent, (WritableChannel)channel);
        NetworkReadableClosableChannelNetty4 readChannel = new NetworkReadableClosableChannelNetty4(buffer);
        ReplicatedContent result = (ReplicatedContent)coreReplicatedContentMarshal.unmarshal((ReadableChannel)readChannel);
        Assert.assertEquals((Object)this.replicatedContent, (Object)result);
    }
}

