/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.helpers.Buffers;
import org.neo4j.causalclustering.messaging.marshalling.InputStreamReadableChannel;
import org.neo4j.causalclustering.messaging.marshalling.OutputStreamWritableChannel;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class StringMarshalTest {
    @Rule
    public final Buffers buffers = new Buffers();

    @Test
    public void shouldSerializeAndDeserializeString() {
        String TEST_STRING = "ABC123_?";
        ByteBuf buffer = this.buffers.buffer();
        StringMarshal.marshal((ByteBuf)buffer, (String)"ABC123_?");
        String reconstructed = StringMarshal.unmarshal((ByteBuf)buffer);
        Assert.assertNotSame((Object)"ABC123_?", (Object)reconstructed);
        Assert.assertEquals((Object)"ABC123_?", (Object)reconstructed);
    }

    @Test
    public void shouldSerializeAndDeserializeEmptyString() {
        String TEST_STRING = "";
        ByteBuf buffer = this.buffers.buffer();
        StringMarshal.marshal((ByteBuf)buffer, (String)"");
        String reconstructed = StringMarshal.unmarshal((ByteBuf)buffer);
        Assert.assertNotSame((Object)"", (Object)reconstructed);
        Assert.assertEquals((Object)"", (Object)reconstructed);
    }

    @Test
    public void shouldSerializeAndDeserializeNull() {
        ByteBuf buffer = this.buffers.buffer();
        StringMarshal.marshal((ByteBuf)buffer, null);
        String reconstructed = StringMarshal.unmarshal((ByteBuf)buffer);
        Assert.assertNull((Object)reconstructed);
    }

    @Test
    public void shouldSerializeAndDeserializeStringUsingChannel() throws IOException {
        String TEST_STRING = "ABC123_?";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        StringMarshal.marshal((WritableChannel)writableChannel, (String)"ABC123_?");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)inputStream);
        String reconstructed = StringMarshal.unmarshal((ReadableChannel)readableChannel);
        Assert.assertNotSame((Object)"ABC123_?", (Object)reconstructed);
        Assert.assertEquals((Object)"ABC123_?", (Object)reconstructed);
    }

    @Test
    public void shouldSerializeAndDeserializeEmptyStringUsingChannel() throws IOException {
        String TEST_STRING = "";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        StringMarshal.marshal((WritableChannel)writableChannel, (String)"");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)inputStream);
        String reconstructed = StringMarshal.unmarshal((ReadableChannel)readableChannel);
        Assert.assertNotSame((Object)"", (Object)reconstructed);
        Assert.assertEquals((Object)"", (Object)reconstructed);
    }

    @Test
    public void shouldSerializeAndDeserializeNullUsingChannel() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        StringMarshal.marshal((WritableChannel)writableChannel, null);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)inputStream);
        String reconstructed = StringMarshal.unmarshal((ReadableChannel)readableChannel);
        Assert.assertNull((Object)reconstructed);
    }
}

