/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.causalclustering.messaging.marshalling.ChunkedReplicatedContent;

public class ChunkedReplicatedContentTest {
    @Test
    public void shouldProvideExpectedMetaData() throws Exception {
        ChunkedInput replicatedContent = ChunkedReplicatedContent.chunked((byte)1, (ChunkedInput)new ThreeChunks(-1, 8));
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        ByteBuf byteBuf = (ByteBuf)replicatedContent.readChunk((ByteBufAllocator)allocator);
        Assertions.assertFalse((boolean)byteBuf.readBoolean());
        Assertions.assertEquals((byte)1, (byte)byteBuf.readByte());
        byteBuf.release();
        byteBuf = (ByteBuf)replicatedContent.readChunk((ByteBufAllocator)allocator);
        Assertions.assertFalse((boolean)byteBuf.readBoolean());
        byteBuf.release();
        byteBuf = (ByteBuf)replicatedContent.readChunk((ByteBufAllocator)allocator);
        Assertions.assertTrue((boolean)byteBuf.readBoolean());
        byteBuf.release();
        Assertions.assertNull((Object)replicatedContent.readChunk((ByteBufAllocator)allocator));
    }

    private class ThreeChunks
    implements ChunkedInput<ByteBuf> {
        private final int length;
        private int leftTowWrite;
        private final int chunkSize;
        private int count;

        ThreeChunks(int length, int chunkSize) {
            this.length = length;
            this.leftTowWrite = length == -1 ? Integer.MAX_VALUE : length;
            this.chunkSize = chunkSize;
        }

        public boolean isEndOfInput() {
            return this.count == 3;
        }

        public void close() {
        }

        public ByteBuf readChunk(ChannelHandlerContext ctx) {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) {
            if (this.count == 3) {
                return null;
            }
            ByteBuf buffer = allocator.buffer(this.chunkSize, this.chunkSize);
            ++this.count;
            int toWrite = Integer.min(this.leftTowWrite, buffer.writableBytes());
            this.leftTowWrite -= toWrite;
            buffer.writerIndex(buffer.writerIndex() + toWrite);
            return buffer;
        }

        public long length() {
            return this.length;
        }

        public long progress() {
            return 0L;
        }
    }
}

