/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.util.Iterator;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.helpers.Buffers;
import org.neo4j.causalclustering.messaging.MessageTooBigException;
import org.neo4j.causalclustering.messaging.marshalling.MaxTotalSize;
import org.neo4j.helpers.collection.Iterators;

public class ByteBufChunkHandlerTest {
    @Rule
    public final Buffers buffers = new Buffers();

    @Test(expected=MessageTooBigException.class)
    public void shouldThrowExceptioIfToLarge() throws Exception {
        MaxTotalSize maxTotalSize = new MaxTotalSize((ChunkedInput)new PredictableChunkedInput(new int[]{10, 1}), 10);
        maxTotalSize.readChunk((ByteBufAllocator)this.buffers);
        maxTotalSize.readChunk((ByteBufAllocator)this.buffers);
    }

    @Test
    public void shouldAllowIfNotTooLarge() throws Exception {
        MaxTotalSize maxTotalSize = new MaxTotalSize((ChunkedInput)new PredictableChunkedInput(new int[]{10, 1}), 11);
        maxTotalSize.readChunk((ByteBufAllocator)this.buffers);
        maxTotalSize.readChunk((ByteBufAllocator)this.buffers);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIllegalSizeValue() {
        new MaxTotalSize((ChunkedInput)new PredictableChunkedInput(new int[0]), -1);
    }

    private class PredictableChunkedInput
    implements ChunkedInput<ByteBuf> {
        private final Iterator<Integer> sizes;

        private PredictableChunkedInput(int ... sizes) {
            this.sizes = Iterators.asIterator((int[])sizes);
        }

        public boolean isEndOfInput() {
            return !this.sizes.hasNext();
        }

        public void close() {
        }

        public ByteBuf readChunk(ChannelHandlerContext ctx) {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) {
            Integer size = this.sizes.next();
            if (size == null) {
                return null;
            }
            return allocator.buffer(size.intValue()).writerIndex(size.intValue());
        }

        public long length() {
            return 0L;
        }

        public long progress() {
            return 0L;
        }
    }
}

