/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.helpers.Buffers;
import org.neo4j.causalclustering.messaging.marshalling.ByteArrayChunkedEncoder;

public class ByteArrayChunkedEncoderTest {
    @Rule
    public final Buffers buffers = new Buffers();

    @Test
    public void shouldWriteToBufferInChunks() {
        int chunkSize = 5;
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6};
        byte[] readData = new byte[6];
        ByteArrayChunkedEncoder byteArraySerializer = new ByteArrayChunkedEncoder(data, chunkSize);
        ByteBuf buffer = byteArraySerializer.readChunk((ByteBufAllocator)this.buffers);
        buffer.readBytes(readData, 0, chunkSize);
        Assert.assertEquals((long)0L, (long)buffer.readableBytes());
        buffer = byteArraySerializer.readChunk((ByteBufAllocator)this.buffers);
        buffer.readBytes(readData, chunkSize, 1);
        Assert.assertArrayEquals((byte[])data, (byte[])readData);
        Assert.assertEquals((long)0L, (long)buffer.readableBytes());
        Assert.assertNull((Object)byteArraySerializer.readChunk((ByteBufAllocator)this.buffers));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowOnTooSmallChunk() {
        new ByteArrayChunkedEncoder(new byte[1], 0);
    }
}

