/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.messaging.SimpleNettyChannel;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class SimpleNettyChannelTest {
    private EmbeddedChannel nettyChannel = new EmbeddedChannel();

    @Test
    public void shouldWriteOnNettyChannel() {
        SimpleNettyChannel channel = new SimpleNettyChannel((Channel)this.nettyChannel, (Log)NullLog.getInstance());
        Object msg = new Object();
        Future writeComplete = channel.write(msg);
        Assert.assertNull((Object)this.nettyChannel.readOutbound());
        Assert.assertFalse((boolean)writeComplete.isDone());
        this.nettyChannel.flush();
        Assert.assertTrue((boolean)writeComplete.isDone());
        Assert.assertEquals((Object)msg, (Object)this.nettyChannel.readOutbound());
    }

    @Test
    public void shouldWriteAndFlushOnNettyChannel() {
        SimpleNettyChannel channel = new SimpleNettyChannel((Channel)this.nettyChannel, (Log)NullLog.getInstance());
        Object msg = new Object();
        Future writeComplete = channel.writeAndFlush(msg);
        Assert.assertTrue((boolean)writeComplete.isDone());
        Assert.assertEquals((Object)msg, (Object)this.nettyChannel.readOutbound());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowWhenWritingOnDisposedChannel() {
        SimpleNettyChannel channel = new SimpleNettyChannel((Channel)this.nettyChannel, (Log)NullLog.getInstance());
        channel.dispose();
        channel.write(new Object());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowWhenWriteAndFlushingOnDisposedChannel() {
        SimpleNettyChannel channel = new SimpleNettyChannel((Channel)this.nettyChannel, (Log)NullLog.getInstance());
        channel.dispose();
        channel.writeAndFlush(new Object());
    }
}

