/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.InputStreamReadableChannel;
import org.neo4j.causalclustering.messaging.marshalling.OutputStreamWritableChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ClusterIdMarshalTest {
    private ChannelMarshal<ClusterId> marshal = ClusterId.Marshal.INSTANCE;

    @Test
    public void shouldMarshalClusterId() throws Throwable {
        ClusterId original = new ClusterId(UUID.randomUUID());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        this.marshal.marshal((Object)original, (WritableChannel)writableChannel);
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        ClusterId result = (ClusterId)this.marshal.unmarshal((ReadableChannel)readableChannel);
        Assert.assertNotSame((Object)original, (Object)result);
        Assert.assertEquals((Object)original, (Object)result);
    }

    @Test
    public void shouldMarshalNullClusterId() throws Throwable {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        this.marshal.marshal(null, (WritableChannel)writableChannel);
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        ClusterId result = (ClusterId)this.marshal.unmarshal((ReadableChannel)readableChannel);
        Assert.assertNull((Object)result);
    }
}

