/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helpers;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.test.TestGraphDatabaseFactory;

public class ClassicNeo4jStore {
    private final File storeDir;
    private final File logicalLogsDir;

    private ClassicNeo4jStore(File storeDir, File logicalLogsDir) {
        this.storeDir = storeDir;
        this.logicalLogsDir = logicalLogsDir;
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    public File getLogicalLogsDir() {
        return this.logicalLogsDir;
    }

    public static Neo4jStoreBuilder builder(File baseDir, FileSystemAbstraction fsa) {
        return new Neo4jStoreBuilder(baseDir, fsa);
    }

    public static class Neo4jStoreBuilder {
        private String dbName = "graph.db";
        private boolean needRecover;
        private int nrOfNodes = 10;
        private String recordsFormat = "standard";
        private final File baseDir;
        private final FileSystemAbstraction fsa;
        private String logicalLogsLocation = "";

        Neo4jStoreBuilder(File baseDir, FileSystemAbstraction fsa) {
            this.baseDir = baseDir;
            this.fsa = fsa;
        }

        public Neo4jStoreBuilder dbName(String string) {
            this.dbName = string;
            return this;
        }

        public Neo4jStoreBuilder needToRecover() {
            this.needRecover = true;
            return this;
        }

        public Neo4jStoreBuilder amountOfNodes(int nodes) {
            this.nrOfNodes = nodes;
            return this;
        }

        public Neo4jStoreBuilder recordFormats(String format) {
            this.recordsFormat = format;
            return this;
        }

        public Neo4jStoreBuilder logicalLogsLocation(String logicalLogsLocation) {
            this.logicalLogsLocation = logicalLogsLocation;
            return this;
        }

        public ClassicNeo4jStore build() throws IOException {
            Neo4jStoreBuilder.createStore(this.baseDir, this.fsa, this.dbName, this.nrOfNodes, this.recordsFormat, this.needRecover, this.logicalLogsLocation);
            File storeDir = new File(this.baseDir, this.dbName);
            return new ClassicNeo4jStore(storeDir, new File(storeDir, this.logicalLogsLocation));
        }

        private static void createStore(File base, FileSystemAbstraction fileSystem, String dbName, int nodesToCreate, String recordFormat, boolean recoveryNeeded, String logicalLogsLocation) throws IOException {
            File storeDir = new File(base, dbName);
            GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fileSystem).newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.record_format, recordFormat).setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).setConfig(GraphDatabaseSettings.logical_logs_location, logicalLogsLocation).newGraphDatabase();
            for (int i = 0; i < nodesToCreate / 2; ++i) {
                File[] fileArray = null;
                try (Transaction tx = db.beginTx();){
                    Node node1 = db.createNode(new Label[]{Label.label((String)("Label-" + i))});
                    Node node2 = db.createNode(new Label[]{Label.label((String)("Label-" + i))});
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)("REL-" + i)));
                    tx.success();
                    continue;
                }
                catch (Throwable object) {
                    fileArray = object;
                    throw object;
                }
            }
            if (recoveryNeeded) {
                File tmpLogs = new File(base, "unrecovered");
                fileSystem.mkdir(tmpLogs);
                File txLogsDir = new File(storeDir, logicalLogsLocation);
                for (File file : fileSystem.listFiles(txLogsDir, TransactionLogFiles.DEFAULT_FILENAME_FILTER)) {
                    fileSystem.copyFile(file, new File(tmpLogs, file.getName()));
                }
                db.shutdown();
                for (File file : fileSystem.listFiles(txLogsDir, TransactionLogFiles.DEFAULT_FILENAME_FILTER)) {
                    fileSystem.deleteFile(file);
                }
                for (File file : fileSystem.listFiles(tmpLogs, TransactionLogFiles.DEFAULT_FILENAME_FILTER)) {
                    fileSystem.copyFile(file, new File(txLogsDir, file.getName()));
                }
            } else {
                db.shutdown();
            }
        }
    }
}

