/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Map;
import java.util.Optional;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.AbstractCoreTopologyService;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

class SharedDiscoveryCoreClient
extends AbstractCoreTopologyService
implements Comparable<SharedDiscoveryCoreClient> {
    private final SharedDiscoveryService sharedDiscoveryService;
    private final CoreServerInfo coreServerInfo;
    private final String localDBName;
    private final boolean refusesToBeLeader;
    private volatile LeaderInfo leaderInfo = LeaderInfo.INITIAL;
    private volatile ReadReplicaTopology readReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile CoreTopology coreTopology = CoreTopology.EMPTY;
    private volatile ReadReplicaTopology localReadReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile CoreTopology localCoreTopology = CoreTopology.EMPTY;

    SharedDiscoveryCoreClient(SharedDiscoveryService sharedDiscoveryService, MemberId member, LogProvider logProvider, Config config) {
        super(config, member, logProvider, logProvider);
        this.localDBName = (String)config.get(CausalClusteringSettings.database);
        this.sharedDiscoveryService = sharedDiscoveryService;
        this.coreServerInfo = CoreServerInfo.from((Config)config);
        this.refusesToBeLeader = (Boolean)config.get(CausalClusteringSettings.refuse_to_be_leader);
    }

    @Override
    public int compareTo(SharedDiscoveryCoreClient o) {
        return Optional.ofNullable(o).map(c -> c.myself.getUuid().compareTo(this.myself.getUuid())).orElse(-1);
    }

    public boolean setClusterId(ClusterId clusterId, String dbName) {
        return this.sharedDiscoveryService.casClusterId(clusterId, dbName);
    }

    public Map<MemberId, RoleInfo> allCoreRoles() {
        return this.sharedDiscoveryService.getCoreRoles();
    }

    public void setLeader0(LeaderInfo newLeader) {
        this.leaderInfo = newLeader;
        this.sharedDiscoveryService.casLeaders(newLeader, this.localDBName);
    }

    public LeaderInfo getLeader() {
        return this.leaderInfo;
    }

    public void init0() {
    }

    public void start0() throws InterruptedException {
        this.coreTopology = this.sharedDiscoveryService.getCoreTopology(this);
        this.localCoreTopology = this.coreTopology.filterTopologyByDb(this.localDBName);
        this.readReplicaTopology = this.sharedDiscoveryService.getReadReplicaTopology();
        this.localReadReplicaTopology = this.readReplicaTopology.filterTopologyByDb(this.localDBName);
        this.sharedDiscoveryService.registerCoreMember(this);
        this.log.info("Registered core server %s", new Object[]{this.myself});
        this.sharedDiscoveryService.waitForClusterFormation();
        this.log.info("Cluster formed");
    }

    public void stop0() {
        this.sharedDiscoveryService.unRegisterCoreMember(this);
        this.log.info("Unregistered core server %s", new Object[]{this.myself});
    }

    public void shutdown0() {
    }

    public String localDBName() {
        return this.localDBName;
    }

    public CoreTopology allCoreServers() {
        return this.coreTopology;
    }

    public CoreTopology localCoreServers() {
        return this.localCoreTopology;
    }

    public ReadReplicaTopology allReadReplicas() {
        return this.readReplicaTopology;
    }

    public ReadReplicaTopology localReadReplicas() {
        return this.localReadReplicaTopology;
    }

    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
        return this.localCoreServers().find(upstream).map(info -> Optional.of(info.getCatchupServer())).orElseGet(() -> this.readReplicaTopology.find(upstream).map(ReadReplicaInfo::getCatchupServer));
    }

    public void handleStepDown0(LeaderInfo steppingDown) {
        this.sharedDiscoveryService.casLeaders(steppingDown, this.localDBName);
    }

    public MemberId getMemberId() {
        return this.myself;
    }

    public CoreServerInfo getCoreServerInfo() {
        return this.coreServerInfo;
    }

    void onCoreTopologyChange(CoreTopology coreTopology) {
        this.log.info("Notified of core topology change " + coreTopology);
        this.coreTopology = coreTopology;
        this.localCoreTopology = coreTopology.filterTopologyByDb(this.localDBName);
        this.listenerService.notifyListeners(coreTopology);
    }

    void onReadReplicaTopologyChange(ReadReplicaTopology readReplicaTopology) {
        this.log.info("Notified of read replica topology change " + readReplicaTopology);
        this.readReplicaTopology = readReplicaTopology;
        this.localReadReplicaTopology = readReplicaTopology.filterTopologyByDb(this.localDBName);
    }

    public boolean refusesToBeLeader() {
        return this.refusesToBeLeader;
    }

    public String toString() {
        return "SharedDiscoveryCoreClient{myself=" + this.myself + ", coreServerInfo=" + this.coreServerInfo + ", refusesToBeLeader=" + this.refusesToBeLeader + ", localDBName='" + this.localDBName + '\'' + ", leaderInfo=" + this.leaderInfo + ", coreTopology=" + this.coreTopology + '}';
    }
}

