/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class MultiRetryStrategyTest {
    private static final Predicate<Integer> ALWAYS_VALID = i -> true;
    private static final Predicate<Integer> NEVER_VALID = i -> false;
    private static final Predicate<Integer> VALID_ON_SECOND_TIME = new Predicate<Integer>(){
        private boolean nextSuccessful;

        @Override
        public boolean test(Integer integer) {
            if (!this.nextSuccessful) {
                this.nextSuccessful = true;
                return false;
            }
            return true;
        }
    };

    @Test
    public void successOnRetryCausesNoDelay() {
        CountingSleeper countingSleeper = new CountingSleeper();
        int retries = 10;
        MultiRetryStrategy subject = new MultiRetryStrategy(0L, (long)retries, (LogProvider)NullLogProvider.getInstance(), (LongConsumer)countingSleeper);
        Integer result = (Integer)subject.apply((Object)3, Function.identity(), ALWAYS_VALID);
        Assert.assertEquals((long)0L, (long)countingSleeper.invocationCount());
        Assert.assertEquals((String)"Function identity should be used to retrieve the expected value", (long)3L, (long)result.intValue());
    }

    @Test
    public void numberOfIterationsDoesNotExceedMaximum() {
        CountingSleeper countingSleeper = new CountingSleeper();
        int retries = 5;
        MultiRetryStrategy subject = new MultiRetryStrategy(0L, (long)retries, (LogProvider)NullLogProvider.getInstance(), (LongConsumer)countingSleeper);
        subject.apply((Object)3, Function.identity(), NEVER_VALID);
        Assert.assertEquals((long)retries, (long)countingSleeper.invocationCount());
    }

    @Test
    public void successfulRetriesBreakTheRetryLoop() {
        CountingSleeper countingSleeper = new CountingSleeper();
        int retries = 5;
        MultiRetryStrategy subject = new MultiRetryStrategy(0L, (long)retries, (LogProvider)NullLogProvider.getInstance(), (LongConsumer)countingSleeper);
        subject.apply((Object)3, Function.identity(), VALID_ON_SECOND_TIME);
        Assert.assertEquals((long)1L, (long)countingSleeper.invocationCount());
    }

    public static MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> testRetryStrategy(int numRetries) {
        return new MultiRetryStrategy(0L, (long)numRetries, (LogProvider)NullLogProvider.getInstance(), (LongConsumer)new CountingSleeper());
    }

    public static class CountingSleeper
    implements LongConsumer {
        private int counter;

        @Override
        public void accept(long l) {
            ++this.counter;
        }

        public int invocationCount() {
            return this.counter;
        }
    }
}

