/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.InitialDiscoveryMembersResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.kernel.configuration.Config;

@RunWith(value=MockitoJUnitRunner.class)
public class InitialDiscoveryMembersResolverTest {
    @Mock
    private HostnameResolver hostnameResolver;

    @Test
    public void shouldReturnEmptyCollectionIfEmptyInitialMembers() {
        Config config = Config.builder().withSetting(CausalClusteringSettings.initial_discovery_members, "").build();
        InitialDiscoveryMembersResolver hostnameResolvingInitialDiscoveryMembersResolver = new InitialDiscoveryMembersResolver(this.hostnameResolver, config);
        Collection result = hostnameResolvingInitialDiscoveryMembersResolver.resolve(Function.identity());
        Assert.assertThat((Object)result, (Matcher)Matchers.empty());
    }

    @Test
    public void shouldResolveAndReturnAllConfiguredAddresses() {
        AdvertisedSocketAddress input1 = new AdvertisedSocketAddress("foo.bar", 123);
        AdvertisedSocketAddress input2 = new AdvertisedSocketAddress("baz.bar", 432);
        AdvertisedSocketAddress input3 = new AdvertisedSocketAddress("quux.bar", 789);
        AdvertisedSocketAddress output1 = new AdvertisedSocketAddress("a.b", 3);
        AdvertisedSocketAddress output2 = new AdvertisedSocketAddress("b.b", 34);
        AdvertisedSocketAddress output3 = new AdvertisedSocketAddress("c.b", 7);
        String configString = Stream.of(input1, input2, input3).map(SocketAddress::toString).collect(Collectors.joining(","));
        Config config = Config.builder().withSetting(CausalClusteringSettings.initial_discovery_members, configString).build();
        Mockito.when((Object)this.hostnameResolver.resolve(input1)).thenReturn(Arrays.asList(output1, output2));
        Mockito.when((Object)this.hostnameResolver.resolve(input2)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.hostnameResolver.resolve(input3)).thenReturn(Collections.singletonList(output3));
        InitialDiscoveryMembersResolver hostnameResolvingInitialDiscoveryMembersResolver = new InitialDiscoveryMembersResolver(this.hostnameResolver, config);
        Collection result = hostnameResolvingInitialDiscoveryMembersResolver.resolve(Function.identity());
        Assert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])new AdvertisedSocketAddress[]{output1, output2, output3}));
    }

    @Test
    public void shouldApplyTransform() {
        AdvertisedSocketAddress input1 = new AdvertisedSocketAddress("foo.bar", 123);
        AdvertisedSocketAddress output1 = new AdvertisedSocketAddress("a.b", 3);
        Config config = Config.builder().withSetting(CausalClusteringSettings.initial_discovery_members, input1.toString()).build();
        Mockito.when((Object)this.hostnameResolver.resolve(input1)).thenReturn(Collections.singletonList(output1));
        InitialDiscoveryMembersResolver hostnameResolvingInitialDiscoveryMembersResolver = new InitialDiscoveryMembersResolver(this.hostnameResolver, config);
        Collection result = hostnameResolvingInitialDiscoveryMembersResolver.resolve(address -> address.toString().toUpperCase());
        Assert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{output1.toString().toUpperCase()}));
    }
}

