/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MultiMap;
import com.hazelcast.nio.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.helpers.CausalClusteringTestHelpers;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.CollectorsUtil;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class HazelcastClusterTopologyTest {
    private static final Set<String> GROUPS = Iterators.asSet((Object[])new String[]{"group1", "group2", "group3"});
    private static final Set<String> DB_NAMES = Stream.of("foo", "bar", "baz").collect(Collectors.toSet());
    private static final String DEFAULT_DB_NAME = "default";
    private static final IntFunction<HashMap<String, String>> DEFAULT_SETTINGS_GENERATOR = i -> {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(CausalClusteringSettings.transaction_advertised_address.name(), "tx:" + (i + 1));
        settings.put(CausalClusteringSettings.raft_advertised_address.name(), "raft:" + (i + 1));
        settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new BoltConnector((String)"bolt").advertised_address.name(), "bolt:" + (i + 1));
        settings.put(new BoltConnector((String)"http").type.name(), "HTTP");
        settings.put(new BoltConnector((String)"http").enabled.name(), "true");
        settings.put(new BoltConnector((String)"http").advertised_address.name(), "http:" + (i + 1));
        return settings;
    };
    private final HazelcastInstance hzInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
    private Map<String, IMap<String, String>> rrAttributeMaps;

    @Before
    public void setup() {
        MultiMap serverGroupsMMap = (MultiMap)Mockito.mock(MultiMap.class);
        Mockito.when((Object)serverGroupsMMap.get(ArgumentMatchers.any())).thenReturn(GROUPS);
        Mockito.when((Object)this.hzInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)serverGroupsMMap);
        this.rrAttributeMaps = (Map)HazelcastClusterTopology.RR_ATTR_KEYS.stream().map(k -> Pair.of((Object)k, (Object)((IMap)Mockito.mock(IMap.class)))).collect(CollectorsUtil.pairsToMap());
    }

    private static List<Config> generateConfigs(int numConfigs) {
        return HazelcastClusterTopologyTest.generateConfigs(numConfigs, DEFAULT_SETTINGS_GENERATOR);
    }

    private static List<Config> generateConfigs(int numConfigs, IntFunction<HashMap<String, String>> generator) {
        return IntStream.range(0, numConfigs).mapToObj(generator).map(Config::defaults).collect(Collectors.toList());
    }

    @Test
    public void shouldCollectReadReplicasAsMap() {
        MemberId memberId = new MemberId(UUID.randomUUID());
        ReadReplicaInfo readReplicaInfo = this.generateReadReplicaInfo();
        Map<MemberId, ReadReplicaInfo> mockedRRs = Collections.singletonMap(memberId, readReplicaInfo);
        this.mockReadReplicaAttributes(mockedRRs);
        Map rrMap = HazelcastClusterTopology.readReplicas((HazelcastInstance)this.hzInstance, (Log)NullLog.getInstance());
        Assert.assertEquals(mockedRRs, (Object)rrMap);
    }

    @Test
    public void shouldValidateNullReadReplicaAttrMaps() {
        MemberId memberId = new MemberId(UUID.randomUUID());
        ReadReplicaInfo readReplicaInfo = this.generateReadReplicaInfo();
        this.mockReadReplicaAttributes(Collections.singletonMap(memberId, readReplicaInfo), Collections.singleton("read_replicas_database_names"), Collections.emptyMap());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        Map rrMap = HazelcastClusterTopology.readReplicas((HazelcastInstance)this.hzInstance, (Log)log);
        Assert.assertEquals(Collections.emptyMap(), (Object)rrMap);
        logProvider.assertContainsMessageContaining("Some, but not all, of the read replica attribute maps are null");
    }

    @Test
    public void shouldValidateReadReplicaAttrMapNullValues() {
        HashMap<MemberId, ReadReplicaInfo> mockedRRs = new HashMap<MemberId, ReadReplicaInfo>();
        MemberId validMemberId = new MemberId(UUID.randomUUID());
        MemberId invalidMemberId = new MemberId(UUID.randomUUID());
        ReadReplicaInfo validReadReplicaInfo = this.generateReadReplicaInfo();
        ReadReplicaInfo invalidReadReplicaInfo = this.generateReadReplicaInfo();
        mockedRRs.put(validMemberId, validReadReplicaInfo);
        mockedRRs.put(invalidMemberId, invalidReadReplicaInfo);
        Map<MemberId, Set<String>> nullAttrValues = Collections.singletonMap(invalidMemberId, Collections.singleton("read-replica-transaction-servers"));
        this.mockReadReplicaAttributes(mockedRRs, Collections.emptySet(), nullAttrValues);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        Map rrMap = HazelcastClusterTopology.readReplicas((HazelcastInstance)this.hzInstance, (Log)log);
        Assert.assertEquals(Collections.singletonMap(validMemberId, validReadReplicaInfo), (Object)rrMap);
        logProvider.assertContainsMessageContaining("Missing attribute %s for read replica");
    }

    @Test
    public void shouldCollectMembersAsAMap() throws Exception {
        int numMembers = 5;
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        List<Config> configs = HazelcastClusterTopologyTest.generateConfigs(numMembers);
        for (int i = 0; i < configs.size(); ++i) {
            MemberId mId = new MemberId(UUID.randomUUID());
            coreMembers.add(mId);
            Config c = configs.get(i);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)mId, (Config)c).getAttributes();
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i), null, attributes, false));
        }
        Map coreMemberMap = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance(), (HazelcastInstance)this.hzInstance);
        for (int i = 0; i < numMembers; ++i) {
            CoreServerInfo coreServerInfo = (CoreServerInfo)coreMemberMap.get(coreMembers.get(i));
            Assert.assertEquals((Object)new AdvertisedSocketAddress("tx", i + 1), (Object)coreServerInfo.getCatchupServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("raft", i + 1), (Object)coreServerInfo.getRaftServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("bolt", i + 1), (Object)coreServerInfo.connectors().boltAddress());
            Assert.assertEquals((Object)coreServerInfo.getDatabaseName(), (Object)DEFAULT_DB_NAME);
            Assert.assertEquals((Object)coreServerInfo.groups(), GROUPS);
        }
    }

    @Test
    public void shouldBuildMemberAttributedWithSpecifiedDBNames() throws Exception {
        int numMembers = 10;
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        Map<Integer, String> dbNames = CausalClusteringTestHelpers.distributeDatabaseNamesToHostNums(numMembers, DB_NAMES);
        IntFunction<HashMap<String, String>> generator = i -> {
            HashMap<String, String> settings = DEFAULT_SETTINGS_GENERATOR.apply(i);
            settings.put(CausalClusteringSettings.database.name(), (String)dbNames.get(i));
            return settings;
        };
        List<Config> configs = HazelcastClusterTopologyTest.generateConfigs(numMembers, generator);
        for (int i2 = 0; i2 < configs.size(); ++i2) {
            MemberId mId = new MemberId(UUID.randomUUID());
            coreMembers.add(mId);
            Config c = configs.get(i2);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)mId, (Config)c).getAttributes();
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i2), null, attributes, false));
        }
        Map coreMemberMap = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance(), (HazelcastInstance)this.hzInstance);
        for (int i3 = 0; i3 < numMembers; ++i3) {
            CoreServerInfo coreServerInfo = (CoreServerInfo)coreMemberMap.get(coreMembers.get(i3));
            String expectedDBName = dbNames.get(i3);
            Assert.assertEquals((Object)expectedDBName, (Object)coreServerInfo.getDatabaseName());
        }
    }

    @Test
    public void shouldLogAndExcludeMembersWithMissingAttributes() throws Exception {
        int numMembers = 4;
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        IntFunction<HashMap<String, String>> generator = i -> {
            HashMap<String, String> settings = DEFAULT_SETTINGS_GENERATOR.apply(i);
            settings.remove(CausalClusteringSettings.transaction_advertised_address.name());
            settings.remove(CausalClusteringSettings.raft_advertised_address.name());
            return settings;
        };
        List<Config> configs = HazelcastClusterTopologyTest.generateConfigs(numMembers, generator);
        for (int i2 = 0; i2 < configs.size(); ++i2) {
            MemberId memberId = new MemberId(UUID.randomUUID());
            coreMembers.add(memberId);
            Config c = configs.get(i2);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)memberId, (Config)c).getAttributes();
            if (i2 == 2) {
                attributes.remove("raft_server");
            }
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i2), null, attributes, false));
        }
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        Map map = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)log, (HazelcastInstance)this.hzInstance);
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(0), (MemberId)coreMembers.get(1), (MemberId)coreMembers.get(3)}));
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(2)})));
        logProvider.assertContainsMessageContaining("Missing member attribute");
    }

    @Test
    public void shouldCorrectlyReturnCoreMemberRoles() {
        int numMembers = 3;
        List members = IntStream.range(0, numMembers).mapToObj(ignored -> new MemberId(UUID.randomUUID())).collect(Collectors.toList());
        IAtomicReference leaderRef = (IAtomicReference)Mockito.mock(IAtomicReference.class);
        MemberId chosenLeaderId = (MemberId)members.get(0);
        Mockito.when((Object)leaderRef.get()).thenReturn((Object)new LeaderInfo(chosenLeaderId, 0L));
        IMap uuidDBMap = (IMap)Mockito.mock(IMap.class);
        Mockito.when((Object)uuidDBMap.keySet()).thenReturn(Collections.singleton(DEFAULT_DB_NAME));
        Mockito.when((Object)this.hzInstance.getAtomicReference(ArgumentMatchers.startsWith((String)"leader_term_for_database_name_"))).thenReturn((Object)leaderRef);
        Mockito.when((Object)this.hzInstance.getMap((String)ArgumentMatchers.eq((Object)"cluster_uuid"))).thenReturn((Object)uuidDBMap);
        Map roleMap = HazelcastClusterTopology.getCoreRoles((HazelcastInstance)this.hzInstance, new HashSet(members));
        Assert.assertEquals((String)"First member was expected to be leader.", (Object)RoleInfo.LEADER, roleMap.get(chosenLeaderId));
    }

    private void mockReadReplicaAttributes(Map<MemberId, ReadReplicaInfo> readReplicaInfos) {
        this.mockReadReplicaAttributes(readReplicaInfos, Collections.emptySet(), Collections.emptyMap());
    }

    private void mockReadReplicaAttributes(Map<MemberId, ReadReplicaInfo> readReplicaInfos, Set<String> missingAttrsMaps, Map<MemberId, Set<String>> nullAttrs) {
        HashSet hzIds = new HashSet();
        readReplicaInfos.forEach((memberId, readReplicaInfo) -> {
            UUID hzId = UUID.randomUUID();
            hzIds.add(hzId.toString());
            this.generateReadReplicaAttributes(hzId, (MemberId)memberId, (ReadReplicaInfo)readReplicaInfo, missingAttrsMaps, nullAttrs.getOrDefault(memberId, Collections.emptySet()));
        });
        this.rrAttributeMaps.forEach((ignored, attrs) -> Mockito.when((Object)attrs.keySet()).thenReturn((Object)hzIds));
    }

    private void generateReadReplicaAttributes(UUID hzId, MemberId memberId, ReadReplicaInfo readReplicaInfo, Set<String> missingAttrsMaps, Set<String> nullAttrs) {
        HashMap<String, BiFunction<MemberId, ReadReplicaInfo, String>> attributeFactories = new HashMap<String, BiFunction<MemberId, ReadReplicaInfo, String>>();
        attributeFactories.put("read_replicas_database_names", (ignored, rr) -> rr.getDatabaseName());
        attributeFactories.put("read-replica-transaction-servers", (ignored, rr) -> rr.getCatchupServer().toString());
        attributeFactories.put("read-replica-member-ids", (mId, ignored) -> mId.getUuid().toString());
        attributeFactories.put("read_replicas", (ignored, rr) -> rr.connectors().toString());
        attributeFactories.entrySet().stream().filter(e -> !missingAttrsMaps.contains(e.getKey())).forEach(e -> {
            String attrValue = nullAttrs.contains(e.getKey()) ? null : (String)((BiFunction)e.getValue()).apply(memberId, readReplicaInfo);
            this.mockReadReplicaAttribute((String)e.getKey(), hzId, attrValue);
        });
    }

    private void mockReadReplicaAttribute(String attrKey, UUID hzId, String attrValue) {
        IMap<String, String> attrs = this.rrAttributeMaps.get(attrKey);
        Mockito.when((Object)attrs.get((Object)hzId.toString())).thenReturn((Object)attrValue);
        Mockito.when((Object)this.hzInstance.getMap(attrKey)).thenReturn(attrs);
    }

    private ReadReplicaInfo generateReadReplicaInfo() {
        IntSupplier portFactory = () -> ThreadLocalRandom.current().nextInt(1000, 10000);
        List<ClientConnectorAddresses.ConnectorUri> connectorUris = Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("losthost", portFactory.getAsInt())));
        ClientConnectorAddresses addresses = new ClientConnectorAddresses(connectorUris);
        return new ReadReplicaInfo(addresses, new AdvertisedSocketAddress("localhost", portFactory.getAsInt()), GROUPS, "foo");
    }
}

