/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.replication.DirectReplicator;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionCommitProcess;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionStateMachine;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class CommitProcessStateMachineCollaborationTest {
    @Test
    public void shouldFailTransactionIfLockSessionChanges() {
        int initialLockSessionId = 23;
        TransactionToApply transactionToApply = new TransactionToApply((TransactionRepresentation)this.physicalTx(initialLockSessionId));
        int finalLockSessionId = 24;
        TransactionCommitProcess localCommitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        ReplicatedTransactionStateMachine stateMachine = new ReplicatedTransactionStateMachine((CommandIndexTracker)Mockito.mock(CommandIndexTracker.class), this.lockState(finalLockSessionId), 16, (LogProvider)NullLogProvider.getInstance(), PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
        stateMachine.installCommitProcess(localCommitProcess, -1L);
        DirectReplicator replicator = new DirectReplicator(stateMachine);
        ReplicatedTransactionCommitProcess commitProcess = new ReplicatedTransactionCommitProcess(replicator);
        try {
            commitProcess.commit(transactionToApply, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
    }

    private PhysicalTransactionRepresentation physicalTx(int lockSessionId) {
        PhysicalTransactionRepresentation physicalTx = (PhysicalTransactionRepresentation)Mockito.mock(PhysicalTransactionRepresentation.class);
        Mockito.when((Object)physicalTx.getLockSessionId()).thenReturn((Object)lockSessionId);
        return physicalTx;
    }

    private ReplicatedLockTokenStateMachine lockState(int lockSessionId) {
        ReplicatedLockTokenStateMachine lockState = (ReplicatedLockTokenStateMachine)Mockito.mock(ReplicatedLockTokenStateMachine.class);
        Mockito.when((Object)lockState.currentToken()).thenReturn((Object)new ReplicatedLockTokenRequest(null, lockSessionId));
        return lockState;
    }
}

