/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.locks;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.replication.DirectReplicator;
import org.neo4j.causalclustering.core.state.machines.locks.LeaderOnlyLockManager;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LeaderOnlyLockManagerTest {
    @Test
    public void shouldIssueLocksOnLeader() throws Exception {
        MemberId me = RaftTestMember.member(0);
        ReplicatedLockTokenStateMachine replicatedLockStateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        DirectReplicator replicator = new DirectReplicator(replicatedLockStateMachine);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)me);
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)client);
        LeaderOnlyLockManager lockManager = new LeaderOnlyLockManager(me, replicator, leaderLocator, locks, replicatedLockStateMachine);
        lockManager.newClient().acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{0L});
    }

    @Test
    public void shouldNotIssueLocksOnNonLeader() throws Exception {
        MemberId me = RaftTestMember.member(0);
        MemberId leader = RaftTestMember.member(1);
        ReplicatedLockTokenStateMachine replicatedLockStateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        DirectReplicator replicator = new DirectReplicator(replicatedLockStateMachine);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)leader);
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)client);
        LeaderOnlyLockManager lockManager = new LeaderOnlyLockManager(me, replicator, leaderLocator, locks, replicatedLockStateMachine);
        Locks.Client lockClient = lockManager.newClient();
        try {
            lockClient.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{0L});
            Assert.fail((String)"Should have thrown exception");
        }
        catch (AcquireLockTimeoutException acquireLockTimeoutException) {
            // empty catch block
        }
    }
}

