/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionRepresentationReplicatedTransaction;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.NetworkWritableChannel;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreReplicatedContentMarshalTest {
    private final ChannelMarshal<ReplicatedContent> marshal = CoreReplicatedContentMarshal.marshaller();

    @Test
    public void shouldMarshalTransactionReference() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(Collections.emptyList());
        representation.setHeader(new byte[]{0}, 1, 1, 1L, 1L, 1L, 1);
        TransactionRepresentationReplicatedTransaction replicatedTx = ReplicatedTransaction.from((TransactionRepresentation)representation);
        this.assertMarshalingEquality(buffer, replicatedTx);
    }

    @Test
    public void shouldMarshalTransactionReferenceWithMissingHeader() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(Collections.emptyList());
        TransactionRepresentationReplicatedTransaction replicatedTx = ReplicatedTransaction.from((TransactionRepresentation)representation);
        this.assertMarshalingEquality(buffer, replicatedTx);
    }

    @Test
    public void shouldMarshalMemberSet() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        MemberIdSet message = new MemberIdSet(Iterators.asSet((Object[])new MemberId[]{new MemberId(UUID.randomUUID()), new MemberId(UUID.randomUUID())}));
        this.assertMarshalingEquality(buffer, (ReplicatedContent)message);
    }

    @Test
    public void shouldMarshalIdRangeRequest() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        ReplicatedIdAllocationRequest message = new ReplicatedIdAllocationRequest(new MemberId(UUID.randomUUID()), IdType.PROPERTY, 100L, 200);
        this.assertMarshalingEquality(buffer, (ReplicatedContent)message);
    }

    @Test
    public void shouldMarshalTokenRequest() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        ArrayList<Command.LabelTokenCommand> commands = new ArrayList<Command.LabelTokenCommand>();
        LabelTokenRecord before = new LabelTokenRecord(0L);
        LabelTokenRecord after = new LabelTokenRecord(0L);
        after.setInUse(true);
        after.setCreated();
        after.setNameId(3232);
        commands.add(new Command.LabelTokenCommand(before, after));
        ReplicatedTokenRequest message = new ReplicatedTokenRequest(TokenType.LABEL, "theLabel", ReplicatedTokenRequestSerializer.commandBytes(commands));
        this.assertMarshalingEquality(buffer, (ReplicatedContent)message);
    }

    private void assertMarshalingEquality(ByteBuf buffer, ReplicatedContent replicatedTx) throws IOException, EndOfStreamException {
        this.marshal.marshal((Object)replicatedTx, (WritableChannel)new NetworkWritableChannel(buffer));
        MatcherAssert.assertThat((Object)this.marshal.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(buffer)), (Matcher)CoreMatchers.equalTo((Object)replicatedTx));
    }

    private void assertMarshalingEquality(ByteBuf buffer, TransactionRepresentationReplicatedTransaction replicatedTx) throws IOException, EndOfStreamException {
        this.marshal.marshal((Object)replicatedTx, (WritableChannel)new NetworkWritableChannel(buffer));
        ReplicatedContent unmarshal = (ReplicatedContent)this.marshal.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(buffer));
        TransactionRepresentation tx = replicatedTx.tx();
        byte[] extraHeader = tx.additionalHeader();
        if (extraHeader == null) {
            ((PhysicalTransactionRepresentation)tx).setHeader(new byte[0], tx.getMasterId(), tx.getAuthorId(), tx.getTimeStarted(), tx.getLatestCommittedTxWhenStarted(), tx.getTimeCommitted(), tx.getLockSessionId());
            extraHeader = tx.additionalHeader();
        }
        TransactionRepresentation representation = ReplicatedTransactionFactory.extractTransactionRepresentation((ReplicatedTransaction)((ReplicatedTransaction)unmarshal), (byte[])extraHeader);
        MatcherAssert.assertThat((Object)representation, (Matcher)CoreMatchers.equalTo((Object)tx));
    }
}

