/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import java.util.Collection;
import org.neo4j.causalclustering.core.consensus.schedule.Delay;
import org.neo4j.causalclustering.core.consensus.schedule.Timer;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.time.FakeClock;

public class OnDemandTimerService
extends TimerService {
    private final FakeClock clock;
    private OnDemandJobScheduler onDemandJobScheduler;

    public OnDemandTimerService(FakeClock clock) {
        super((JobScheduler)new OnDemandJobScheduler(), (LogProvider)NullLogProvider.getInstance());
        this.clock = clock;
        this.onDemandJobScheduler = (OnDemandJobScheduler)this.scheduler;
    }

    public void invoke(TimerService.TimerName name) {
        Collection timers = this.getTimers(name);
        for (Timer timer : timers) {
            Delay delay = timer.delay();
            this.clock.forward(delay.amount(), delay.unit());
        }
        for (Timer timer : timers) {
            timer.invoke();
        }
        this.onDemandJobScheduler.runJob();
    }
}

