/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.AppendLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class CandidateTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);
    private LogProvider logProvider = NullLogProvider.getInstance();

    @Test
    public void shouldBeElectedLeaderOnReceivingGrantedVoteResponseWithCurrentTerm() throws Exception {
        RaftState state = RaftStateBuilder.raftState().term(1L).myself(this.myself).votingMembers(this.member1, this.member2).replicationMembers(this.member1, this.member2).build();
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(state.term()).from(this.member1).grant().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.LEADER, (Object)outcome.getRole());
        Assert.assertTrue((boolean)outcome.electionTimeoutRenewed());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)CoreMatchers.hasItem((Object)new AppendLogEntry(0L, new RaftLogEntry(state.term(), (ReplicatedContent)new NewLeaderBarrier()))));
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)CoreMatchers.hasItems((Object[])new RaftMessages.Directed[]{new RaftMessages.Directed(this.member1, (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.myself, state.term(), -1L, -1L)), new RaftMessages.Directed(this.member2, (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.myself, state.term(), -1L, -1L))}));
    }

    @Test
    public void shouldStayAsCandidateOnReceivingDeniedVoteResponseWithCurrentTerm() throws Exception {
        RaftState state = this.newState();
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(state.term()).from(this.member1).deny().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    @Test
    public void shouldUpdateTermOnReceivingVoteResponseWithLaterTerm() throws Exception {
        RaftState state = this.newState();
        long voterTerm = state.term() + 1L;
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(voterTerm).from(this.member1).grant().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)outcome.getRole());
        Assert.assertEquals((long)voterTerm, (long)outcome.getTerm());
    }

    @Test
    public void shouldRejectVoteResponseWithOldTerm() throws Exception {
        RaftState state = this.newState();
        long voterTerm = state.term() - 1L;
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(voterTerm).from(this.member1).grant().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    @Test
    public void shouldDeclineVoteRequestsIfFromSameTerm() throws Throwable {
        RaftState raftState = this.newState();
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteRequest().candidate(this.member1).from(this.member1).term(raftState.term()).build(), (ReadableRaftState)raftState, this.log());
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)CoreMatchers.hasItem((Object)new RaftMessages.Directed(this.member1, (RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(raftState.term()).from(this.myself).deny().build())));
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    @Test
    public void shouldBecomeFollowerIfReceiveVoteRequestFromLaterTerm() throws Throwable {
        RaftState raftState = this.newState();
        long newTerm = raftState.term() + 1L;
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteRequest().candidate(this.member1).from(this.member1).term(newTerm).build(), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((long)newTerm, (long)outcome.getTerm());
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)outcome.getRole());
        Assert.assertThat((Object)outcome.getVotesForMe(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)CoreMatchers.hasItem((Object)new RaftMessages.Directed(this.member1, (RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(newTerm).from(this.myself).grant().build())));
    }

    @Test
    public void shouldDeclinePreVoteFromSameTerm() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).build();
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.preVoteRequest().candidate(this.member1).from(this.member1).term(raftState.term()).build(), (ReadableRaftState)raftState, this.log());
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)CoreMatchers.hasItem((Object)new RaftMessages.Directed(this.member1, (RaftMessages.RaftMessage)TestMessageBuilders.preVoteResponse().term(raftState.term()).from(this.myself).deny().build())));
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    @Test
    public void shouldBecomeFollowerIfReceivePreVoteRequestFromLaterTerm() throws Throwable {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).build();
        long newTerm = raftState.term() + 1L;
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.preVoteRequest().candidate(this.member1).from(this.member1).term(newTerm).build(), (ReadableRaftState)raftState, this.log());
        Assert.assertEquals((long)newTerm, (long)outcome.getTerm());
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)outcome.getRole());
        Assert.assertThat((Object)outcome.getVotesForMe(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)outcome.getOutgoingMessages(), (Matcher)CoreMatchers.hasItem((Object)new RaftMessages.Directed(this.member1, (RaftMessages.RaftMessage)TestMessageBuilders.preVoteResponse().term(newTerm).from(this.myself).deny().build())));
    }

    public RaftState newState() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).build();
    }

    private Log log() {
        return this.logProvider.getLog(this.getClass());
    }
}

