/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.membership.RaftGroup;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.marshalling.ReplicatedContentHandler;

public class RaftTestGroup
implements RaftGroup<MemberId> {
    private final Set<MemberId> members = new HashSet<MemberId>();

    public RaftTestGroup(Set<MemberId> members) {
        this.members.addAll(members);
    }

    public RaftTestGroup(int ... memberIds) {
        for (int memberId : memberIds) {
            this.members.add(RaftTestMember.member(memberId));
        }
    }

    public RaftTestGroup(MemberId ... memberIds) {
        this.members.addAll(Arrays.asList(memberIds));
    }

    public Set<MemberId> getMembers() {
        return this.members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaftTestGroup that = (RaftTestGroup)o;
        return this.members.equals(that.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }

    public String toString() {
        return String.format("RaftTestGroup{members=%s}", this.members);
    }

    public void handle(ReplicatedContentHandler contentHandler) {
        throw new UnsupportedOperationException("No handler for this " + this.getClass());
    }
}

