/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.time.Clock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.time.Clocks;

public class SegmentedRaftLogRotationTruncationPruneTest {
    private FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();

    @After
    public void tearDown() throws Exception {
        this.fileSystem.close();
    }

    @Test
    public void shouldPruneAwaySingleEntriesIfRotationHappenedEveryEntry() throws Exception {
        int i;
        RaftLog log = this.createRaftLog();
        long term = 0L;
        for (i = 0; i < 10; ++i) {
            log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(i))});
        }
        Assert.assertEquals((long)-1L, (long)log.prevIndex());
        for (i = 0; i < 9; ++i) {
            log.prune((long)i);
            Assert.assertEquals((long)i, (long)log.prevIndex());
        }
        log.prune(9L);
        Assert.assertEquals((long)8L, (long)log.prevIndex());
    }

    @Test
    public void shouldPruneAwaySingleEntriesAfterTruncationIfRotationHappenedEveryEntry() throws Exception {
        int i;
        RaftLog log = this.createRaftLog();
        long term = 0L;
        for (i = 0; i < 10; ++i) {
            log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(i))});
        }
        log.truncate(9L);
        log.truncate(8L);
        log.truncate(7L);
        Assert.assertEquals((long)-1L, (long)log.prevIndex());
        for (i = 0; i <= 5; ++i) {
            log.prune((long)i);
            Assert.assertEquals((long)i, (long)log.prevIndex());
        }
        for (i = 5; i < 10; ++i) {
            log.prune((long)i);
            Assert.assertEquals((long)5L, (long)log.prevIndex());
        }
    }

    private RaftLog createRaftLog() throws Exception {
        File directory = new File("raft-log");
        EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
        fileSystem.mkdir(directory);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory("1 entries", (LogProvider)logProvider).newInstance();
        SegmentedRaftLog newRaftLog = new SegmentedRaftLog((FileSystemAbstraction)fileSystem, directory, 1L, (ChannelMarshal)new DummyRaftableContentSerializer(), (LogProvider)logProvider, 8, (Clock)Clocks.fakeClock(), (JobScheduler)new OnDemandJobScheduler(), pruningStrategy);
        newRaftLog.start();
        return newRaftLog;
    }
}

