/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.log.segmented.Reader;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;

public class ReaderTest {
    private final FileSystemAbstraction fsa = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
    private final File file = (File)Mockito.mock(File.class);

    @Test
    public void shouldCloseChannelOnClose() throws Exception {
        Mockito.when((Object)this.fsa.open(this.file, OpenMode.READ)).thenReturn((Object)this.channel);
        Reader reader = new Reader(this.fsa, this.file, 0L);
        reader.close();
        ((StoreChannel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    public void shouldUpdateTimeStamp() throws Exception {
        Reader reader = new Reader(this.fsa, this.file, 0L);
        int expected = 123;
        reader.setTimeStamp((long)expected);
        Assert.assertEquals((long)expected, (long)reader.getTimeStamp());
    }
}

