/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.consensus.log.segmented.Segments;
import org.neo4j.helpers.collection.Visitor;

abstract class PruningStrategyTest {
    Segments segments = (Segments)Mockito.mock(Segments.class);
    List<SegmentFile> files;

    PruningStrategyTest() {
    }

    ArrayList<SegmentFile> createSegmentFiles(int size) {
        ArrayList<SegmentFile> list = new ArrayList<SegmentFile>(size);
        for (int i = 0; i < size; ++i) {
            SegmentFile file = (SegmentFile)Mockito.mock(SegmentFile.class);
            Mockito.when((Object)file.header()).thenReturn((Object)this.testSegmentHeader(i));
            Mockito.when((Object)file.size()).thenReturn((Object)1L);
            list.add(file);
        }
        return list;
    }

    @Before
    public void mockSegmentVisitor() {
        ((Segments)Mockito.doAnswer(invocation -> {
            Visitor visitor = (Visitor)invocation.getArgument(0);
            ListIterator<SegmentFile> itr = this.files.listIterator(this.files.size());
            boolean terminate = false;
            while (itr.hasPrevious() && !terminate) {
                terminate = visitor.visit((Object)itr.previous());
            }
            return null;
        }).when((Object)this.segments)).visitBackwards((Visitor)ArgumentMatchers.any());
    }

    private SegmentHeader testSegmentHeader(long value) {
        return new SegmentHeader(-1L, -1L, value - 1L, -1L);
    }
}

