/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.pruning;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.log.pruning.PruningScheduler;
import org.neo4j.causalclustering.core.state.RaftLogPruner;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OnDemandJobScheduler;

public class PruningSchedulerTest {
    private final RaftLogPruner logPruner = (RaftLogPruner)Mockito.mock(RaftLogPruner.class);
    private final OnDemandJobScheduler jobScheduler = (OnDemandJobScheduler)Mockito.spy((Object)new OnDemandJobScheduler());

    @Test
    public void shouldScheduleTheCheckPointerJobOnStart() {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        ((OnDemandJobScheduler)Mockito.verify((Object)this.jobScheduler, (VerificationMode)Mockito.times((int)1))).schedule((Group)ArgumentMatchers.eq((Object)Group.RAFT_LOG_PRUNING), (Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)20L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void shouldRescheduleTheJobAfterARun() throws Throwable {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Runnable scheduledJob = this.jobScheduler.getJob();
        Assert.assertNotNull((Object)scheduledJob);
        this.jobScheduler.runJob();
        ((OnDemandJobScheduler)Mockito.verify((Object)this.jobScheduler, (VerificationMode)Mockito.times((int)2))).schedule((Group)ArgumentMatchers.eq((Object)Group.RAFT_LOG_PRUNING), (Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)20L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((RaftLogPruner)Mockito.verify((Object)this.logPruner, (VerificationMode)Mockito.times((int)1))).prune();
        Assert.assertEquals((Object)scheduledJob, (Object)this.jobScheduler.getJob());
    }

    @Test
    public void shouldNotRescheduleAJobWhenStopped() {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        scheduler.stop();
        Assert.assertNull((Object)this.jobScheduler.getJob());
    }

    @Test
    public void stoppedJobCantBeInvoked() throws Throwable {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 10L, (LogProvider)NullLogProvider.getInstance());
        scheduler.start();
        this.jobScheduler.runJob();
        ((RaftLogPruner)Mockito.verify((Object)this.logPruner)).prune();
        scheduler.stop();
        scheduler.start();
        this.jobScheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logPruner});
    }

    @Test(timeout=5000L)
    public void shouldWaitOnStopUntilTheRunningCheckpointIsDone() throws Throwable {
        AtomicReference ex = new AtomicReference();
        final DoubleLatch checkPointerLatch = new DoubleLatch(1);
        RaftLogPruner logPruner = new RaftLogPruner(null, null, Clock.systemUTC()){

            public void prune() {
                checkPointerLatch.startAndWaitForAllToStart();
                checkPointerLatch.waitForAllToFinish();
            }
        };
        PruningScheduler scheduler = new PruningScheduler(logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        scheduler.start();
        Thread runCheckPointer = new Thread(() -> ((OnDemandJobScheduler)this.jobScheduler).runJob());
        runCheckPointer.start();
        checkPointerLatch.waitForAllToStart();
        Thread stopper = new Thread(() -> {
            try {
                scheduler.stop();
            }
            catch (Throwable throwable) {
                ex.set(throwable);
            }
        });
        stopper.start();
        checkPointerLatch.finish();
        runCheckPointer.join();
        stopper.join();
        Assert.assertNull(ex.get());
    }
}

