/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveCache;

@RunWith(value=Parameterized.class)
public class ConsecutiveCacheTest {
    private final int capacity;
    private ConsecutiveCache<Integer> cache;
    private Integer[] evictions;

    public ConsecutiveCacheTest(int capacity) {
        this.capacity = capacity;
        this.evictions = new Integer[capacity];
    }

    @Parameterized.Parameters(name="capacity={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({1}, {2}, {3}, {4}, {8}, {1024});
    }

    @Before
    public void setup() {
        this.cache = new ConsecutiveCache(this.capacity);
    }

    @Test
    public void testEmptyInvariants() {
        Assert.assertEquals((long)0L, (long)this.cache.size());
        for (int i = 0; i < this.capacity; ++i) {
            Assert.assertNull((Object)this.cache.get((long)i));
        }
    }

    @Test
    public void testCacheFill() {
        int i;
        for (i = 0; i < this.capacity; ++i) {
            this.cache.put((long)i, (Object)i, (Object[])this.evictions);
            Assert.assertTrue((boolean)Stream.of(this.evictions).allMatch(Objects::isNull));
            Assert.assertEquals((long)(i + 1), (long)this.cache.size());
        }
        for (i = 0; i < this.capacity; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)this.cache.get((long)i)).intValue());
        }
    }

    @Test
    public void testCacheMultipleFills() {
        int i;
        for (i = 0; i < this.capacity; ++i) {
            this.cache.put((long)i, (Object)i, (Object[])this.evictions);
        }
        for (i = this.capacity; i < 10 * this.capacity; ++i) {
            this.cache.put((long)i, (Object)i, (Object[])this.evictions);
            Assert.assertEquals((long)(i - this.capacity), (long)this.evictions[0].intValue());
            Assert.assertTrue((boolean)Stream.of(this.evictions).skip(1L).allMatch(Objects::isNull));
            Assert.assertEquals((long)this.capacity, (long)this.cache.size());
        }
    }

    @Test
    public void testCacheClearing() {
        int i;
        for (i = 0; i < this.capacity; ++i) {
            this.cache.put((long)i, (Object)i, (Object[])this.evictions);
        }
        this.cache.clear((Object[])this.evictions);
        for (i = 0; i < this.capacity; ++i) {
            Assert.assertEquals((long)i, (long)this.evictions[i].intValue());
            Assert.assertNull((Object)this.cache.get((long)i));
        }
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test
    public void testEntryOverride() {
        int i;
        for (i = 0; i < this.capacity; ++i) {
            this.cache.put((long)i, (Object)i, (Object[])this.evictions);
        }
        this.cache.put((long)(this.capacity / 2), (Object)10000, (Object[])this.evictions);
        for (i = 0; i < this.capacity; ++i) {
            if (i == this.capacity / 2) continue;
            Assert.assertEquals((long)i, (long)this.evictions[i].intValue());
            Assert.assertNull((Object)this.cache.get((long)i));
        }
        Assert.assertEquals((long)10000L, (long)((Integer)this.cache.get((long)(this.capacity / 2))).intValue());
    }

    @Test
    public void testEntrySkip() {
        int i;
        for (i = 0; i < this.capacity; ++i) {
            this.cache.put((long)i, (Object)i, (Object[])this.evictions);
        }
        this.cache.put((long)(this.capacity + 1), (Object)10000, (Object[])this.evictions);
        for (i = 0; i < this.capacity; ++i) {
            Assert.assertEquals((long)i, (long)this.evictions[i].intValue());
            Assert.assertNull((Object)this.cache.get((long)i));
        }
        Assert.assertEquals((long)10000L, (long)((Integer)this.cache.get((long)(this.capacity + 1))).intValue());
    }

    @Test
    public void testPruning() {
        int i;
        for (int i2 = 0; i2 < this.capacity; ++i2) {
            this.cache.put((long)i2, (Object)i2, (Object[])this.evictions);
        }
        int upToIndex = this.capacity / 2;
        this.cache.prune((long)upToIndex, (Object[])this.evictions);
        for (i = 0; i <= upToIndex; ++i) {
            Assert.assertNull((Object)this.cache.get((long)i));
            Assert.assertEquals((long)i, (long)this.evictions[i].intValue());
        }
        for (i = upToIndex + 1; i < this.capacity; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)this.cache.get((long)i)).intValue());
        }
    }

    @Test
    public void testRemoval() {
        int i;
        for (i = 0; i < this.capacity; ++i) {
            this.cache.put((long)i, (Object)i, (Object[])this.evictions);
        }
        for (i = 0; i < this.capacity; ++i) {
            Integer removed = (Integer)this.cache.remove();
            Assert.assertEquals((long)i, (long)removed.intValue());
        }
        Assert.assertNull((Object)this.cache.remove());
    }

    @Test
    public void testTruncation() {
        int i;
        for (int i2 = 0; i2 < this.capacity; ++i2) {
            this.cache.put((long)i2, (Object)i2, (Object[])this.evictions);
        }
        int fromIndex = this.capacity / 2;
        this.cache.truncate((long)fromIndex, (Object[])this.evictions);
        for (i = 0; i < fromIndex; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)this.cache.get((long)i)).intValue());
        }
        for (i = fromIndex; i < this.capacity; ++i) {
            Assert.assertNull((Object)this.cache.get((long)i));
            Assert.assertEquals((long)i, (long)this.evictions[this.capacity - i - 1].intValue());
        }
    }
}

