/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;

public abstract class RaftLogContractTest {
    public abstract RaftLog createRaftLog();

    @Test
    public void shouldReportCorrectDefaultValuesOnEmptyLog() throws Exception {
        RaftLog log = this.createRaftLog();
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)log.prevIndex(), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)log.readEntryTerm(0L), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)log.readEntryTerm(-1L), (Matcher)CoreMatchers.is((Object)-1L));
    }

    @Test
    public void shouldResetHighTermOnTruncate() throws Exception {
        RaftLog log = this.createRaftLog();
        log.append(new RaftLogEntry[]{new RaftLogEntry(45L, (ReplicatedContent)ReplicatedInteger.valueOf(99)), new RaftLogEntry(46L, (ReplicatedContent)ReplicatedInteger.valueOf(99)), new RaftLogEntry(47L, (ReplicatedContent)ReplicatedInteger.valueOf(99))});
        log.truncate(1L);
        log.append(new RaftLogEntry[]{new RaftLogEntry(46L, (ReplicatedContent)ReplicatedInteger.valueOf(9999))});
        MatcherAssert.assertThat((Object)log.readEntryTerm(1L), (Matcher)CoreMatchers.is((Object)46L));
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void shouldAppendDataAndNotCommitImmediately() throws Exception {
        RaftLog log = this.createRaftLog();
        RaftLogEntry logEntry = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        log.append(new RaftLogEntry[]{logEntry});
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 0L), (Matcher)CoreMatchers.equalTo((Object)logEntry));
    }

    @Test
    public void shouldTruncatePreviouslyAppendedEntries() throws Exception {
        RaftLog log = this.createRaftLog();
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2));
        log.append(new RaftLogEntry[]{logEntryA, logEntryB});
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)1L));
        log.truncate(1L);
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldReplacePreviouslyAppendedEntries() throws Exception {
        RaftLog log = this.createRaftLog();
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2));
        RaftLogEntry logEntryC = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(3));
        RaftLogEntry logEntryD = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(4));
        RaftLogEntry logEntryE = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(5));
        log.append(new RaftLogEntry[]{logEntryA, logEntryB, logEntryC});
        log.truncate(1L);
        log.append(new RaftLogEntry[]{logEntryD, logEntryE});
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 0L), (Matcher)CoreMatchers.equalTo((Object)logEntryA));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 1L), (Matcher)CoreMatchers.equalTo((Object)logEntryD));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 2L), (Matcher)CoreMatchers.equalTo((Object)logEntryE));
    }

    @Test
    public void shouldHaveNoEffectWhenTruncatingNonExistingEntries() throws Exception {
        RaftLog log = this.createRaftLog();
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2));
        log.append(new RaftLogEntry[]{logEntryA, logEntryB});
        try {
            log.truncate(5L);
            Assert.fail((String)"Truncate at index after append index should never be attempted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 0L), (Matcher)CoreMatchers.equalTo((Object)logEntryA));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 1L), (Matcher)CoreMatchers.equalTo((Object)logEntryB));
    }

    @Test
    public void shouldLogDifferentContentTypes() throws Exception {
        RaftLog log = this.createRaftLog();
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedString.valueOf("hejzxcjkzhxcjkxz"));
        log.append(new RaftLogEntry[]{logEntryA, logEntryB});
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 0L), (Matcher)CoreMatchers.equalTo((Object)logEntryA));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 1L), (Matcher)CoreMatchers.equalTo((Object)logEntryB));
    }

    @Test
    public void shouldRejectNonMonotonicTermsForEntries() throws Exception {
        RaftLog log = this.createRaftLog();
        log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1)), new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        try {
            log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(3))});
            Assert.fail((String)"Should have failed because of non-monotonic terms");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldAppendAndThenTruncateSubsequentEntry() throws Exception {
        RaftLog log = this.createRaftLog();
        log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0))});
        long toBeSpared = log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        long toTruncate = log.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        log.truncate(toTruncate);
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)toBeSpared));
        MatcherAssert.assertThat((Object)log.readEntryTerm(toBeSpared), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldAppendAfterTruncating() throws Exception {
        RaftLog log = this.createRaftLog();
        log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0))});
        long toCommit = log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        long toTruncate = log.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        log.truncate(toTruncate);
        long lastAppended = log.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(3))});
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)lastAppended));
        MatcherAssert.assertThat((Object)log.readEntryTerm(toCommit), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)log.readEntryTerm(lastAppended), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void shouldEventuallyPrune() throws Exception {
        RaftLog log = this.createRaftLog();
        int term = 0;
        long safeIndex = -1L;
        long prunedIndex = -1L;
        while (prunedIndex == -1L) {
            for (int i = 0; i < 100; ++i) {
                log.append(new RaftLogEntry[]{new RaftLogEntry((long)term, (ReplicatedContent)ReplicatedInteger.valueOf(10 * term))});
                ++term;
            }
            safeIndex = log.appendIndex() - 50L;
            prunedIndex = log.prune(safeIndex);
        }
        MatcherAssert.assertThat((Object)prunedIndex, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(safeIndex)));
        Assert.assertEquals((long)prunedIndex, (long)log.prevIndex());
        Assert.assertEquals((long)prunedIndex, (long)log.readEntryTerm(prunedIndex));
        long[] expectedVal = new long[]{prunedIndex + 1L};
        log.getEntryCursor(prunedIndex + 1L).forAll(entry -> {
            long l = expectedVal[0];
            expectedVal[0] = l + 1L;
            MatcherAssert.assertThat((Object)entry.content(), (Matcher)CoreMatchers.is((Object)ReplicatedInteger.valueOf(10 * (int)l)));
        });
        MatcherAssert.assertThat((Object)log, RaftLogHelper.hasNoContent(prunedIndex));
    }

    @Test
    public void shouldSkipAheadInEmptyLog() throws Exception {
        RaftLog log = this.createRaftLog();
        long skipIndex = 10L;
        long skipTerm = 2L;
        log.skip(skipIndex, skipTerm);
        Assert.assertEquals((long)skipIndex, (long)log.appendIndex());
        Assert.assertEquals((long)skipTerm, (long)log.readEntryTerm(skipIndex));
    }

    @Test
    public void shouldSkipAheadInLogWithContent() throws Exception {
        RaftLog log = this.createRaftLog();
        long term = 0L;
        int entryCount = 5;
        for (int i = 0; i < entryCount; ++i) {
            log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(i))});
        }
        long skipIndex = entryCount + 5;
        long skipTerm = term + 2L;
        log.skip(skipIndex, skipTerm);
        Assert.assertEquals((long)skipIndex, (long)log.appendIndex());
        Assert.assertEquals((long)skipTerm, (long)log.readEntryTerm(skipIndex));
    }

    @Test
    public void shouldNotSkipInLogWithLaterContent() throws Exception {
        RaftLog log = this.createRaftLog();
        long term = 0L;
        int entryCount = 5;
        for (int i = 0; i < entryCount; ++i) {
            log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(i))});
        }
        long lastIndex = log.appendIndex();
        long skipIndex = entryCount - 2;
        log.skip(skipIndex, term);
        Assert.assertEquals((long)lastIndex, (long)log.appendIndex());
        Assert.assertEquals((long)term, (long)log.readEntryTerm(skipIndex));
    }

    @Test
    public void shouldBeAbleToAppendAfterSkipping() throws Exception {
        RaftLog log = this.createRaftLog();
        long skipIndex = 5L;
        long term = 0L;
        log.skip(skipIndex, term);
        int newContentValue = 100;
        long newEntryIndex = skipIndex + 1L;
        long appendedIndex = log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(newContentValue))});
        Assert.assertEquals((long)newEntryIndex, (long)log.appendIndex());
        Assert.assertEquals((long)newEntryIndex, (long)appendedIndex);
        try {
            RaftLogHelper.readLogEntry((ReadableRaftLog)log, skipIndex);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, newEntryIndex).content(), (Matcher)CoreMatchers.is((Object)ReplicatedInteger.valueOf(newContentValue)));
    }

    @Test
    public void pruneShouldNotChangePrevIndexAfterSkipping() throws Exception {
        RaftLog log = this.createRaftLog();
        long term = 0L;
        for (int i = 0; i < 2000; ++i) {
            log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(i))});
        }
        long skipIndex = 3000L;
        log.skip(skipIndex, term);
        Assert.assertEquals((long)skipIndex, (long)log.prevIndex());
        log.prune(skipIndex);
        Assert.assertEquals((long)skipIndex, (long)log.prevIndex());
    }

    @Test
    public void shouldProperlyReportExistenceOfIndexesAfterSkipping() throws Exception {
        RaftLog log = this.createRaftLog();
        long term = 0L;
        long existingEntryIndex = log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(100))});
        long skipIndex = 15L;
        log.skip(skipIndex, term);
        Assert.assertEquals((long)skipIndex, (long)log.appendIndex());
        for (long i = existingEntryIndex + 1L; i < skipIndex + 2L; ++i) {
            try {
                RaftLogHelper.readLogEntry((ReadableRaftLog)log, i);
                Assert.fail((String)("Should have thrown exception at index " + i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldThrowExceptionWhenReadingAnEntryWhichHasBeenPruned() throws Exception {
        RaftLog log = this.createRaftLog();
        log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)this.string(1024))});
        log.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)this.string(1024))});
        log.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)this.string(1024))});
        log.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)this.string(1024))});
        log.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)this.string(1024))});
        long pruneIndex = log.prune(4L);
        MatcherAssert.assertThat((Object)pruneIndex, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(2L)));
        long term = log.readEntryTerm(1L);
        RaftLogCursor cursor = log.getEntryCursor(1L);
        if (cursor.next()) {
            Assert.fail();
        }
        Assert.assertEquals((long)-1L, (long)term);
    }

    private ReplicatedString string(int numberOfCharacters) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numberOfCharacters; ++i) {
            builder.append(String.valueOf(i));
        }
        return ReplicatedString.valueOf(builder.toString());
    }
}

