/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityTimers;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.membership.RaftGroup;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembership;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipManager;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.core.consensus.outcome.ConsensusOutcome;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.causalclustering.core.consensus.shipping.RaftLogShippingManager;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.replication.SendToMyself;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class RaftMachineBuilder {
    private final MemberId member;
    private int expectedClusterSize;
    private RaftGroup.Builder memberSetBuilder;
    private TermState termState = new TermState();
    private StateStorage<TermState> termStateStorage = new InMemoryStateStorage((Object)this.termState);
    private StateStorage<VoteState> voteStateStorage = new InMemoryStateStorage((Object)new VoteState());
    private RaftLog raftLog = new InMemoryRaftLog();
    private TimerService timerService;
    private Inbound<RaftMessages.RaftMessage> inbound = handler -> {};
    private Outbound<MemberId, RaftMessages.RaftMessage> outbound = (to, message, block) -> {};
    private LogProvider logProvider = NullLogProvider.getInstance();
    private Clock clock = Clocks.systemClock();
    private long term = this.termState.currentTerm();
    private long electionTimeout = 500L;
    private long heartbeatInterval = 150L;
    private long catchupTimeout = 30000L;
    private long retryTimeMillis = this.electionTimeout / 2L;
    private int catchupBatchSize = 64;
    private int maxAllowedShippingLag = 256;
    private StateStorage<RaftMembershipState> raftMembership = new InMemoryStateStorage((Object)new RaftMembershipState());
    private Monitors monitors = new Monitors();
    private CommitListener commitListener = commitIndex -> {};
    private InFlightCache inFlightCache = new ConsecutiveInFlightCache();

    public RaftMachineBuilder(MemberId member, int expectedClusterSize, RaftGroup.Builder memberSetBuilder) {
        this.member = member;
        this.expectedClusterSize = expectedClusterSize;
        this.memberSetBuilder = memberSetBuilder;
    }

    public RaftMachine build() {
        this.termState.update(this.term);
        LeaderAvailabilityTimers leaderAvailabilityTimers = new LeaderAvailabilityTimers(Duration.ofMillis(this.electionTimeout), Duration.ofMillis(this.heartbeatInterval), this.clock, this.timerService, this.logProvider);
        SendToMyself leaderOnlyReplicator = new SendToMyself(this.member, this.outbound);
        RaftMembershipManager membershipManager = new RaftMembershipManager(leaderOnlyReplicator, this.memberSetBuilder, (ReadableRaftLog)this.raftLog, this.logProvider, this.expectedClusterSize, leaderAvailabilityTimers.getElectionTimeout(), this.clock, this.catchupTimeout, this.raftMembership);
        membershipManager.setRecoverFromIndexSupplier(() -> 0L);
        RaftLogShippingManager logShipping = new RaftLogShippingManager(this.outbound, this.logProvider, (ReadableRaftLog)this.raftLog, this.timerService, this.clock, this.member, (RaftMembership)membershipManager, this.retryTimeMillis, this.catchupBatchSize, this.maxAllowedShippingLag, this.inFlightCache);
        RaftMachine raft = new RaftMachine(this.member, this.termStateStorage, this.voteStateStorage, this.raftLog, leaderAvailabilityTimers, this.outbound, this.logProvider, membershipManager, logShipping, this.inFlightCache, false, false, this.monitors);
        this.inbound.registerHandler(incomingMessage -> {
            try {
                ConsensusOutcome outcome = raft.handle(incomingMessage);
                this.commitListener.notifyCommitted(outcome.getCommitIndex());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            membershipManager.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return raft;
    }

    public RaftMachineBuilder electionTimeout(long electionTimeout) {
        this.electionTimeout = electionTimeout;
        return this;
    }

    public RaftMachineBuilder heartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public RaftMachineBuilder timerService(TimerService timerService) {
        this.timerService = timerService;
        return this;
    }

    public RaftMachineBuilder outbound(Outbound<MemberId, RaftMessages.RaftMessage> outbound) {
        this.outbound = outbound;
        return this;
    }

    public RaftMachineBuilder inbound(Inbound<RaftMessages.RaftMessage> inbound) {
        this.inbound = inbound;
        return this;
    }

    public RaftMachineBuilder raftLog(RaftLog raftLog) {
        this.raftLog = raftLog;
        return this;
    }

    public RaftMachineBuilder inFlightCache(InFlightCache inFlightCache) {
        this.inFlightCache = inFlightCache;
        return this;
    }

    public RaftMachineBuilder clock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public RaftMachineBuilder commitListener(CommitListener commitListener) {
        this.commitListener = commitListener;
        return this;
    }

    RaftMachineBuilder monitors(Monitors monitors) {
        this.monitors = monitors;
        return this;
    }

    public RaftMachineBuilder term(long term) {
        this.term = term;
        return this;
    }

    public static interface CommitListener {
        public void notifyCommitted(long var1);
    }
}

