/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import co.unruly.matchers.StreamMatchers;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.SupportedProtocolCreator;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.SupportedProtocols;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class SupportedProtocolCreatorTest {
    private NullLogProvider log = NullLogProvider.getInstance();

    @Test
    public void shouldReturnRaftProtocol() {
        Config config = Config.defaults();
        ApplicationSupportedProtocols supportedRaftProtocol = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedRaftProtocol();
        Assert.assertThat((Object)supportedRaftProtocol.identifier(), (Matcher)Matchers.equalTo((Object)Protocol.ApplicationProtocolCategory.RAFT));
    }

    @Test
    public void shouldReturnEmptyVersionSupportedRaftProtocolIfNoVersionsConfigured() {
        Config config = Config.defaults();
        ApplicationSupportedProtocols supportedRaftProtocol = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedRaftProtocol();
        Assert.assertThat((Object)supportedRaftProtocol.versions(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldFilterUnknownRaftImplementations() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.raft_implementations, (String)"1, 2, 3");
        ApplicationSupportedProtocols supportedRaftProtocol = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedRaftProtocol();
        Assert.assertThat((Object)supportedRaftProtocol.versions(), (Matcher)Matchers.contains((Object[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldReturnConfiguredRaftProtocolVersions() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.raft_implementations, (String)"1");
        ApplicationSupportedProtocols supportedRaftProtocol = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedRaftProtocol();
        Assert.assertThat((Object)supportedRaftProtocol.versions(), (Matcher)Matchers.contains((Object[])new Integer[]{1}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfVersionsSpecifiedButAllUnknown() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.raft_implementations, (String)String.valueOf(Integer.MAX_VALUE));
        ApplicationSupportedProtocols supportedRaftProtocol = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedRaftProtocol();
    }

    @Test
    public void shouldNotReturnModifiersIfNoVersionsSpecified() {
        Config config = Config.defaults();
        List supportedModifierProtocols = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedModifierProtocols();
        Assert.assertThat((Object)supportedModifierProtocols, (Matcher)Matchers.empty());
    }

    @Test
    public void shouldReturnACompressionModifierIfCompressionVersionsSpecified() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.compression_implementations, (String)Protocol.ModifierProtocols.COMPRESSION_SNAPPY.implementation());
        List supportedModifierProtocols = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedModifierProtocols();
        Stream<Protocol.Category> identifiers = supportedModifierProtocols.stream().map(SupportedProtocols::identifier);
        Assert.assertThat(identifiers, (Matcher)StreamMatchers.contains((Object[])new Protocol.Category[]{Protocol.ModifierProtocolCategory.COMPRESSION}));
    }

    @Test
    public void shouldReturnCompressionWithVersionsSpecified() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.compression_implementations, (String)Protocol.ModifierProtocols.COMPRESSION_SNAPPY.implementation());
        List supportedModifierProtocols = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedModifierProtocols();
        List versions = ((ModifierSupportedProtocols)supportedModifierProtocols.get(0)).versions();
        Assert.assertThat((Object)versions, (Matcher)Matchers.contains((Object[])new String[]{Protocol.ModifierProtocols.COMPRESSION_SNAPPY.implementation()}));
    }

    @Test
    public void shouldReturnCompressionWithVersionsSpecifiedCaseInsensitive() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.compression_implementations, (String)Protocol.ModifierProtocols.COMPRESSION_SNAPPY.implementation().toLowerCase());
        List supportedModifierProtocols = new SupportedProtocolCreator(config, (LogProvider)this.log).createSupportedModifierProtocols();
        List versions = ((ModifierSupportedProtocols)supportedModifierProtocols.get(0)).versions();
        Assert.assertThat((Object)versions, (Matcher)Matchers.contains((Object[])new String[]{Protocol.ModifierProtocols.COMPRESSION_SNAPPY.implementation()}));
    }
}

