/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.EnterpriseCoreEditionModule;
import org.neo4j.causalclustering.core.state.machines.id.FreeIdFilteredIdGeneratorFactory;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.test.causalclustering.ClusterRule;

public class EnterpriseCoreEditionModuleIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule();

    @Test
    public void createBufferedIdComponentsByDefault() throws Exception {
        Cluster<?> cluster = this.clusterRule.startCluster();
        CoreClusterMember leader = cluster.awaitLeader();
        DependencyResolver dependencyResolver = leader.database().getDependencyResolver();
        IdController idController = (IdController)dependencyResolver.resolveDependency(IdController.class);
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)dependencyResolver.resolveDependency(IdGeneratorFactory.class);
        Assert.assertThat((Object)idController, (Matcher)Matchers.instanceOf(BufferedIdController.class));
        Assert.assertThat((Object)idGeneratorFactory, (Matcher)Matchers.instanceOf(FreeIdFilteredIdGeneratorFactory.class));
    }

    @Test
    public void fileWatcherFileNameFilter() {
        DatabaseLayout layout = this.clusterRule.testDirectory().databaseLayout();
        Predicate filter = EnterpriseCoreEditionModule.fileWatcherFileNameFilter();
        String metadataStoreName = layout.metadataStore().getName();
        Assert.assertFalse((boolean)filter.test(metadataStoreName));
        Assert.assertFalse((boolean)filter.test(layout.nodeStore().getName()));
        Assert.assertTrue((boolean)filter.test("neostore.transaction.db.1"));
        Assert.assertTrue((boolean)filter.test("index.db.any"));
        Assert.assertTrue((boolean)filter.test("temp-copy"));
        Assert.assertTrue((boolean)filter.test(metadataStoreName + ".cacheprof"));
    }
}

